/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.ColorTable;
import quicktime.qd.GDevice;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.movies.Track;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public final class PixMap
extends QTHandleRef
implements QuickTimeLib {
    private static Object linkage;
    public static final int kNativeSize = 50;
    private boolean isOff;
    static /* synthetic */ Class class$quicktime$qd$PixMap;

    public static PixMap fromGraphicsExporter(GraphicsExporter graphicsExporter) {
        int[] nArray = new int[]{0};
        int n = PixMap.GraphicsExportGetInputPixmap(QTObject.ID(graphicsExporter), nArray);
        return new PixMap(nArray[0], (Object)graphicsExporter, false);
    }

    public static PixMap fromQDGraphics(QDGraphics qDGraphics) {
        return new PixMap(PixMap.GetGWorldPixMap(QTObject.ID(qDGraphics)), (Object)qDGraphics, qDGraphics.isOffscreen());
    }

    public static PixMap fromGDevice(GDevice gDevice) {
        return new PixMap(PixMap.getIntFromHandle(QTObject.ID(gDevice), 22), (Object)gDevice, !gDevice.testAttribute(13));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PixMap fromTrack(Track track) throws StdQTException {
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n = PixMap.GetTrackMatte(QTObject.ID(track));
            StdQTException.checkError(PixMap.GetMoviesError());
        }
        if (n == 0) {
            return null;
        }
        return new PixMap(n, null, true);
    }

    private PixMap(int n, Object object, boolean bl) {
        super(n, object, true);
        this.doLock();
        this.isOff = bl;
    }

    public boolean isOffscreen() {
        return this.isOff;
    }

    public int getRowBytes() {
        return this.getShortAt(4) & 0x3FFF;
    }

    public int getPixelSize() {
        return this.getShortAt(32);
    }

    public int getPixelFormat() {
        int n = this.getIntAt(38);
        return n != 0 ? n : this.getPixelSize();
    }

    public RawEncodedImage getPixelData() {
        return RawEncodedImage.fromPixMap(this);
    }

    public QDRect getBounds() {
        if (QTSession.isCurrentOS(4)) {
            QDRect qDRect = new QDRect();
            PixMap.GetPixBounds(this._ID(), qDRect.getBytes());
            return qDRect;
        }
        byte[] byArray = new byte[8];
        this.getBytesAt(6, 8, byArray, 0);
        return QDRect.fromArray(byArray, 8);
    }

    public ColorTable getColorTable() {
        return ColorTable.fromPixMap(this);
    }

    protected void doLock() {
        PixMap.LockPixels(this._ID());
    }

    protected void doUnlock() {
        PixMap.UnlockPixels(this._ID());
    }

    public String toString() {
        return super.toString() + "[Bounds=" + this.getBounds() + "]";
    }

    private static native int GraphicsExportGetInputPixmap(int var0, int[] var1);

    private static native int GetGWorldPixMap(int var0);

    private static native byte LockPixels(int var0);

    private static native void UnlockPixels(int var0);

    private static native int GetTrackMatte(int var0);

    private static native short GetMoviesError();

    private static native int getIntFromHandle(int var0, int var1);

    private static native int GetPixBounds(int var0, byte[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$qd$PixMap == null ? (class$quicktime$qd$PixMap = PixMap.class$("quicktime.qd.PixMap")) : class$quicktime$qd$PixMap);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

