/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.UtilException;

public final class RotateTransformData
extends QTByteObject
implements Cloneable {
    public static final int kNativeSize = 8;
    static final long serialVersionUID = -5583319263995802834L;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public RotateTransformData() {
        super(8);
    }

    public RotateTransformData(int n, float f) {
        this();
        this.setAxis(n);
        this.setRadian(f);
    }

    private RotateTransformData(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[8];
        RotateTransformData rotateTransformData = new RotateTransformData();
        objectInputStream.read(rotateTransformData.getBytes());
        try {
            EndianOrder.flipBigEndianToNative(rotateTransformData, 0, RotateTransformData.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        System.arraycopy(rotateTransformData.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RotateTransformData rotateTransformData = (RotateTransformData)this.clone();
        try {
            EndianOrder.flipNativeToBigEndian(rotateTransformData, 0, RotateTransformData.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        objectOutputStream.write(rotateTransformData.getBytes());
    }

    public int getAxis() {
        return this.getIntAt(0);
    }

    public float getRadian() {
        return this.getFloatAt(4);
    }

    public void setAxis(int n) {
        this.setIntAt(0, n);
    }

    public void setRadian(float f) {
        this.setFloatAt(4, f);
    }

    public Object clone() {
        return new RotateTransformData(this.bytes);
    }

    public String toString() {
        return this.getClass().getName();
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
    }
}

