/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.sound.ExtScheduledSoundHeader;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class SndCommand
extends QTPointerRef
implements PrimitivesLib {
    private static Object linkage;
    public static final int kNativeSize = 8;
    private ExtScheduledSoundHeader keepBuffer;
    static /* synthetic */ Class class$quicktime$sound$SndCommand;

    public SndCommand(int n) throws QTException {
        super(8, true);
        this.setCmd(n);
    }

    public SndCommand(int n, int n2, int n3) throws QTException {
        super(8, true);
        this.setCmd(n);
        this.setParam1(n2);
        this.setParam2(n3);
    }

    public void setCmd(int n) {
        this.setShortAt(0, (short)n);
    }

    public int getCmd() {
        return QTUtils.UShort2Int(this.getShortAt(0));
    }

    public void setParam1(int n) {
        this.setShortAt(2, (short)n);
    }

    public int getParam1() {
        return this.getShortAt(2);
    }

    public void setParam2(int n) {
        this.setIntAt(4, n);
    }

    public int getParam2() {
        return this.getIntAt(4);
    }

    public void setBuffer(ExtScheduledSoundHeader extScheduledSoundHeader) {
        int n = this.getCmd();
        if (n == 81 || n == 80 || n == 52) {
            this.setIntAt(4, QTObject.ID(extScheduledSoundHeader));
            this.keepBuffer = extScheduledSoundHeader;
        }
    }

    public ExtScheduledSoundHeader getBuffer() {
        int n = this.getCmd();
        if (n == 81 || n == 80 || n == 52) {
            return this.keepBuffer;
        }
        return null;
    }

    public void setVolumes(float f, float f2) {
        int n = this.getCmd();
        if (n != 46) {
            return;
        }
        int n2 = QTUtils.X2ShortFix(f2) << 16;
        short s = QTUtils.X2ShortFix(f);
        this.setIntAt(4, n2 | s);
    }

    public float getRightVolume() {
        int n = this.getCmd();
        int n2 = this.getParam2();
        if (n == 47) {
            int n3 = SndCommand.getIntFromPointer(n2, 0);
            return QTUtils.ShortFix2X((short)(n3 >>> 16));
        }
        if (n == 46) {
            return QTUtils.ShortFix2X((short)(n2 >>> 16));
        }
        return 0.0f;
    }

    public float getLeftVolume() {
        int n = this.getCmd();
        int n2 = this.getParam2();
        if (n == 47) {
            int n3 = SndCommand.getIntFromPointer(n2, 0);
            return QTUtils.ShortFix2X((short)n3);
        }
        if (n == 46) {
            return QTUtils.ShortFix2X((short)n2);
        }
        return 0.0f;
    }

    public String toString() {
        return this.getClass().getName() + "[cmd=" + this.getCmd() + ",param1=" + this.getParam1() + ",param2=" + this.getParam2() + "]";
    }

    private static native short getShortFromPointer(int var0, int var1);

    private static native int getIntFromPointer(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$sound$SndCommand == null ? (class$quicktime$sound$SndCommand = SndCommand.class$("quicktime.sound.SndCommand")) : class$quicktime$sound$SndCommand);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

