/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.jdirect.SoundLib;
import quicktime.sound.SndInfo;
import quicktime.sound.SoundComponentData;
import quicktime.sound.SoundException;
import quicktime.util.QTHandle;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class SndHandle
extends QTHandle
implements QuickTimeLib,
SoundLib {
    private static Object linkage;
    private QTPointerRef buf;
    static /* synthetic */ Class class$quicktime$sound$SndHandle;

    public SndHandle() throws QTException {
        super(200, false);
    }

    public SndHandle(int n, boolean bl) throws QTException {
        super(n, bl);
    }

    public SndHandle(int n, float f, int n2, int n3) throws QTException {
        this(n, f, n2, n3, 60);
    }

    public SndHandle(int n, float f, int n2, int n3, int n4) throws QTException {
        super(100, false);
        int n5 = this.setupHeader(n, f, n2, n3, n4, 0);
        this.setSize(n5);
    }

    public int setupHeader(int n, float f, int n2, int n3, int n4) throws SoundException {
        return this.setupHeader(n, f, n2, n3, 60, n4);
    }

    public int setupHeader(int n, float f, int n2, int n3, int n4, int n5) throws SoundException {
        short[] sArray = new short[]{0};
        SoundException.checkError(SndHandle.SetupSndHeader(this._ID(), (short)n, QTUtils.X2UFix(f), (short)n2, n3, (short)n4, n5, sArray));
        return sArray[0];
    }

    public final int getSoundHeaderOffset() throws SoundException {
        int[] nArray = new int[]{0};
        SoundException.checkError(SndHandle.GetSoundHeaderOffset(this._ID(), nArray));
        return nArray[0];
    }

    public QTPointerRef getSoundData() throws QTException {
        if (this.buf != null) {
            return this.buf;
        }
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        SoundComponentData soundComponentData = new SoundComponentData();
        SoundException.checkError(SndHandle.ParseSndHeader(this._ID(), soundComponentData.getBytes(), nArray, nArray2));
        if (nArray2[0] >= this.getSize()) {
            throw new QTException("No data in SoundHandle yet");
        }
        this.lock();
        return this.toQTPointer(nArray2[0], this.getSize() - nArray2[0]);
    }

    public void appendSoundData(QTPointerRef qTPointerRef) throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        SoundComponentData soundComponentData = new SoundComponentData();
        SoundException.checkError(SndHandle.ParseSndHeader(this._ID(), soundComponentData.getBytes(), nArray, nArray2));
        if (qTPointerRef != null) {
            this.setSize(nArray2[0] + qTPointerRef.getSize());
            SndHandle.BlockMove(QTObject.ID(qTPointerRef), this.lockAndDeref(nArray2[0]), qTPointerRef.getSize());
        } else {
            this.setSize(this.getSoundHeaderOffset());
        }
        this.buf = null;
        this.setIntAt(this.getSoundHeaderOffset(), 0);
    }

    public void appendSoundBuffer(int n) throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        SoundComponentData soundComponentData = new SoundComponentData();
        SoundException.checkError(SndHandle.ParseSndHeader(this._ID(), soundComponentData.getBytes(), nArray, nArray2));
        this.setSize(nArray2[0] + n);
        this.buf = null;
        this.setIntAt(this.getSoundHeaderOffset(), 0);
    }

    public void setSoundData(QTPointerRef qTPointerRef) throws QTException {
        int n = this.getSoundHeaderOffset();
        this.setIntAt(n, QTObject.ID(qTPointerRef));
        this.buf = qTPointerRef;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        SoundComponentData soundComponentData = new SoundComponentData();
        SoundException.checkError(SndHandle.ParseSndHeader(this._ID(), soundComponentData.getBytes(), nArray, nArray2));
        this.setSize(nArray2[0]);
    }

    public final SndInfo parseSndHeader() throws SoundException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        SoundComponentData soundComponentData = new SoundComponentData();
        SoundException.checkError(SndHandle.ParseSndHeader(this._ID(), soundComponentData.getBytes(), nArray, nArray2));
        return new SndInfo(soundComponentData, nArray[0], nArray2[0]);
    }

    private static native short SetupSndHeader(int var0, short var1, int var2, short var3, int var4, short var5, int var6, short[] var7);

    private static native short GetSoundHeaderOffset(int var0, int[] var1);

    private static native void BlockMove(int var0, int var1, int var2);

    private static native short ParseSndHeader(int var0, byte[] var1, int[] var2, int[] var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$sound$SndHandle == null ? (class$quicktime$sound$SndHandle = SndHandle.class$("quicktime.sound.SndHandle")) : class$quicktime$sound$SndHandle);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

