/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTObject;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.sound.SoundException;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTPointer;
import quicktime.util.QTUtils;

public final class SoundComponentData
extends QTByteObject
implements PrimitivesLib {
    private static Object linkage;
    public static final int kNativeSize = 28;
    private QTPointer buff;
    private static final long serialVersionUID = -7514870412490785051L;
    static /* synthetic */ Class class$quicktime$sound$SoundComponentData;

    public SoundComponentData() {
        super(28);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        this.bytes = new byte[28];
        objectInputStream.read(this.bytes);
        for (n = 0; n < 8; n += 4) {
            SoundComponentData.setIntInArray(this.bytes, n, EndianOrder.flipBigEndianToNative32(SoundComponentData.getIntFromArray(this.bytes, n)));
        }
        for (n = 8; n < 12; n += 2) {
            SoundComponentData.setShortInArray(this.bytes, n, EndianOrder.flipBigEndianToNative16(SoundComponentData.getShortFromArray(this.bytes, n)));
        }
        n = 0;
        while (true) {
            SoundComponentData.setIntInArray(this.bytes, n, EndianOrder.flipBigEndianToNative32(SoundComponentData.getIntFromArray(this.bytes, n)));
            n += 4;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[28];
        for (n = 0; n < 8; n += 4) {
            SoundComponentData.setIntInArray(byArray, n, EndianOrder.flipNativeToBigEndian32(SoundComponentData.getIntFromArray(this.getBytes(), n)));
        }
        for (n = 8; n < 12; n += 2) {
            SoundComponentData.setShortInArray(byArray, n, EndianOrder.flipNativeToBigEndian16(SoundComponentData.getShortFromArray(this.getBytes(), n)));
        }
        for (n = 12; n < 28; n += 4) {
            SoundComponentData.setIntInArray(byArray, n, EndianOrder.flipNativeToBigEndian32(SoundComponentData.getIntFromArray(this.getBytes(), n)));
        }
        SoundComponentData.setIntInArray(byArray, 20, 0);
        objectOutputStream.write(byArray);
    }

    public final int getFlags() {
        return this.getIntAt(0);
    }

    public final void setFlags(int n) {
        this.setIntAt(0, n);
    }

    public final int getFormat() {
        return this.getIntAt(4);
    }

    public final void setFormat(int n) {
        this.setIntAt(4, n);
    }

    public final int getNumChannels() {
        return this.getShortAt(8);
    }

    public final void setNumChannels(int n) {
        this.setShortAt(8, (short)n);
    }

    public final int getSampleSize() {
        return this.getShortAt(10);
    }

    public final void setSampleSize(int n) {
        this.setShortAt(10, (short)n);
    }

    public final float getSampleRate() {
        return QTUtils.UFix2X(this.getIntAt(12));
    }

    public final void setSampleRate(float f) {
        this.setIntAt(12, QTUtils.X2UFix(f));
    }

    public final int getSampleCount() {
        return this.getIntAt(16);
    }

    public final void setSampleCount(int n) {
        this.setIntAt(16, n);
    }

    public final QTPointer getBuffer() {
        return QTPointer.fromSCData(this);
    }

    public final void setBuffer(QTPointer qTPointer) throws SoundException {
        if (qTPointer.getSize() < this.getSampleSize() / 8 * this.getSampleCount()) {
            throw new SoundException(-50);
        }
        this.setIntAt(20, QTObject.ID(qTPointer));
        this.buff = qTPointer;
    }

    public String toString() {
        return this.getClass().getName() + "[flags=" + this.getFlags() + ",format=" + QTUtils.fromOSType(this.getFormat()) + ",numChannels=" + this.getNumChannels() + ",sampleSize=" + this.getSampleSize() + ",sampleRate=" + this.getSampleRate() + ",sampleCount=" + this.getSampleCount() + "]";
    }

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$sound$SoundComponentData == null ? (class$quicktime$sound$SoundComponentData = SoundComponentData.class$("quicktime.sound.SoundComponentData")) : class$quicktime$sound$SoundComponentData);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

