/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.image.CodecComponent;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;
import quicktime.util.UtilException;

public final class CodecInfo
extends QTByteObject
implements QuickTimeLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 72;
    static final long serialVersionUID = 1284575243605950382L;
    static /* synthetic */ Class class$quicktime$std$image$CodecInfo;

    public CodecInfo(int n, CodecComponent codecComponent) throws StdQTException {
        super(72);
        short s = CodecInfo.GetCodecInfo(this.bytes, n, QTObject.ID(codecComponent));
        StdQTException.checkError(s);
    }

    private CodecInfo(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n;
        this.bytes = new byte[72];
        objectInputStream.read(this.bytes);
        for (n = 32; n < 36; n += 2) {
            CodecInfo.setShortInArray(this.bytes, 32, EndianOrder.flipBigEndianToNative16(CodecInfo.getShortFromArray(this.bytes, n)));
        }
        for (n = 36; n < 52; n += 4) {
            CodecInfo.setIntInArray(this.bytes, 34, EndianOrder.flipBigEndianToNative32(CodecInfo.getIntFromArray(this.bytes, n)));
        }
        for (n = 54; n < 58; n += 2) {
            CodecInfo.setShortInArray(this.bytes, 54, EndianOrder.flipBigEndianToNative16(CodecInfo.getShortFromArray(this.bytes, n)));
        }
        for (n = 60; n < 68; n += 2) {
            CodecInfo.setShortInArray(this.bytes, 54, EndianOrder.flipBigEndianToNative16(CodecInfo.getShortFromArray(this.bytes, n)));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[72];
        System.arraycopy(this.getBytes(), 0, byArray, 0, 72);
        for (n = 32; n < 36; n += 2) {
            CodecInfo.setShortInArray(this.bytes, n, EndianOrder.flipNativeToBigEndian16(CodecInfo.getShortFromArray(this.bytes, n)));
        }
        for (n = 36; n < 52; n += 4) {
            CodecInfo.setIntInArray(this.bytes, n, EndianOrder.flipNativeToBigEndian32(CodecInfo.getIntFromArray(this.bytes, n)));
        }
        for (n = 54; n < 58; n += 2) {
            CodecInfo.setShortInArray(this.bytes, n, EndianOrder.flipNativeToBigEndian16(CodecInfo.getShortFromArray(this.bytes, n)));
        }
        for (n = 60; n < 68; n += 2) {
            CodecInfo.setShortInArray(this.bytes, n, EndianOrder.flipNativeToBigEndian16(CodecInfo.getShortFromArray(this.bytes, n)));
        }
        CodecInfo.setIntInArray(this.bytes, 60, 0);
        objectOutputStream.write(byArray);
    }

    public static int codecVersion() throws StdQTException {
        int[] nArray = new int[1];
        short s = CodecInfo.CodecManagerVersion(nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public String getTypeName() throws UtilException {
        return this.getPStringAt(0);
    }

    public short getVersion() {
        return this.getShortAt(32);
    }

    public short getRevisionLevel() {
        return this.getShortAt(34);
    }

    public int getVendor() {
        return this.getIntAt(36);
    }

    public int getDecompressFlags() {
        return this.getIntAt(40);
    }

    public int getCompressFlags() {
        return this.getIntAt(44);
    }

    public int getFormatFlags() {
        return this.getIntAt(48);
    }

    public int getCompressionAccuracy() {
        return QTUtils.UByte2Int(this.getByteAt(52));
    }

    public int getDecompressionAccuracy() {
        return QTUtils.UByte2Int(this.getByteAt(53));
    }

    public int getCompressionSpeed() {
        return QTUtils.UShort2Int(this.getShortAt(54));
    }

    public int getDecompressionSpeed() {
        return QTUtils.UShort2Int(this.getShortAt(56));
    }

    public int getCompressionLevel() {
        return QTUtils.UByte2Int(this.getByteAt(58));
    }

    public short getMinimumHeight() {
        return this.getShortAt(60);
    }

    public short getMinimumWidth() {
        return this.getShortAt(62);
    }

    public String toString() {
        return this.getClass().getName() + "[version=" + this.getVersion() + "revisionLevel=" + this.getRevisionLevel() + "vendor=" + this.getVendor() + "decompressFlags=" + this.getDecompressFlags() + "compressFlags=" + this.getCompressFlags() + "formatFlags=" + this.getFormatFlags() + "compressionAccuracy=" + this.getCompressionAccuracy() + "decompressionAccuracy=" + this.getDecompressionAccuracy() + "compressionLevel=" + this.getCompressionLevel() + "minimumHeight=" + this.getMinimumHeight() + "minimumWidth=" + this.getMinimumWidth() + "]";
    }

    public Object clone() {
        return new CodecInfo(this.bytes);
    }

    private static native short GetCodecInfo(byte[] var0, int var1, int var2);

    private static native short CodecManagerVersion(int[] var0);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native short getShortFromArray(byte[] var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$image$CodecInfo == null ? (class$quicktime$std$image$CodecInfo = CodecInfo.class$("quicktime.std.image.CodecInfo")) : class$quicktime$std$image$CodecInfo);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

