/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;

public class ICMPixelFormatInfo
extends QTByteObject
implements QuickTimeLib {
    private static Object linkage;
    private static final int kNativeSize = 36;
    private static byte[] ar;
    static final long serialVersionUID = 8739457055061219117L;
    static /* synthetic */ Class class$quicktime$std$image$ICMPixelFormatInfo;

    public static boolean isValidPixelFormat(int n) {
        short s = ICMPixelFormatInfo.ICMGetPixelFormatInfo(n, ar);
        return s == 0;
    }

    public static ICMPixelFormatInfo setPixelFormatInfo(int n) throws StdQTException {
        if (!QTSession.isCurrentOS(4)) {
            ICMPixelFormatInfo iCMPixelFormatInfo = new ICMPixelFormatInfo();
            short s = ICMPixelFormatInfo.ICMSetPixelFormatInfo(n, iCMPixelFormatInfo.getBytes());
            StdQTException.checkError(s);
            return iCMPixelFormatInfo;
        }
        throw new QTRuntimeException("Unsupported OS");
    }

    public static ICMPixelFormatInfo getPixelFormatInfo(int n) throws StdQTException {
        ICMPixelFormatInfo iCMPixelFormatInfo = new ICMPixelFormatInfo();
        short s = ICMPixelFormatInfo.ICMGetPixelFormatInfo(n, iCMPixelFormatInfo.getBytes());
        StdQTException.checkError(s);
        return iCMPixelFormatInfo;
    }

    private ICMPixelFormatInfo() {
        super(36);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[36];
        objectInputStream.read(this.bytes);
        int n = ICMPixelFormatInfo.getIntFromArray(this.bytes, 0);
        int n2 = EndianOrder.flipBigEndianToNative32(n);
        ICMPixelFormatInfo.setIntInArray(this.bytes, 0, n2);
        int n3 = ICMPixelFormatInfo.getIntFromArray(this.bytes, 4);
        int n4 = EndianOrder.flipBigEndianToNative32(n3);
        ICMPixelFormatInfo.setIntInArray(this.bytes, 4, n4);
        for (int i = 8; i < 36; i += 2) {
            short s = ICMPixelFormatInfo.getShortFromArray(this.bytes, i);
            short s2 = EndianOrder.flipBigEndianToNative16(s);
            ICMPixelFormatInfo.setShortInArray(this.getBytes(), i, s2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[36];
        int n = ICMPixelFormatInfo.getIntFromArray(this.getBytes(), 0);
        int n2 = EndianOrder.flipNativeToBigEndian32(n);
        ICMPixelFormatInfo.setIntInArray(byArray, 0, n2);
        int n3 = this.getFormatFlags();
        int n4 = EndianOrder.flipNativeToBigEndian32(n);
        ICMPixelFormatInfo.setIntInArray(byArray, 4, n4);
        for (int i = 8; i < 36; i += 2) {
            short s = ICMPixelFormatInfo.getShortFromArray(byArray, i);
            short s2 = EndianOrder.flipNativeToBigEndian16(s);
            ICMPixelFormatInfo.setShortInArray(byArray, i, s2);
        }
        objectOutputStream.write(byArray);
    }

    public int getFormatFlags() {
        return this.getIntAt(4);
    }

    public String toString() {
        return this.getClass().getName() + "[formatFlags=" + this.getFormatFlags() + "]";
    }

    private static native short ICMSetPixelFormatInfo(int var0, byte[] var1);

    private static native short ICMGetPixelFormatInfo(int var0, byte[] var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native short getShortFromArray(byte[] var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$image$ICMPixelFormatInfo == null ? (class$quicktime$std$image$ICMPixelFormatInfo = ICMPixelFormatInfo.class$("quicktime.std.image.ICMPixelFormatInfo")) : class$quicktime$std$image$ICMPixelFormatInfo);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
        ar = new byte[36];
    }
}

