/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies;

import java.awt.Dimension;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.GDevice;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.Matrix;
import quicktime.std.movies.LoadSettings;
import quicktime.std.movies.Movie;
import quicktime.std.movies.TimeInfo;
import quicktime.std.movies.TrackEditState;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.Media;
import quicktime.std.movies.media.UserData;
import quicktime.std.qtcomponents.MovieImportInfo;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;

public final class Track
extends QTObject
implements QuickTimeLib {
    private static Object linkage;
    Object owner;
    static /* synthetic */ Class class$quicktime$std$movies$Track;

    public static Track fromMedia(Media media) throws QTException {
        int n = Track.GetMediaTrack(QTObject.ID(media));
        StdQTException.checkError(Track.GetMoviesError());
        return new Track(n, media);
    }

    public static MovieImportInfo fromMovieImporterFile(MovieImporter movieImporter, QTFile qTFile, Movie movie, Track track, int n, int n2) throws QTException {
        int[] nArray = track == null ? null : new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n3 = Track.MovieImportFile(QTObject.ID(movieImporter), qTFile.getFSSpec(true, 256), QTObject.ID(movie), QTObject.ID(track), nArray, n, nArray2, n2, nArray3);
        StdQTException.checkError(n3);
        int n4 = 0;
        if ((n2 & 4) != 0) {
            n4 = track != null ? QTObject.ID(track) : nArray[0];
        }
        Track track2 = n4 == 0 ? null : new Track(n4, movie);
        return new MovieImportInfo(track2, nArray2[0], nArray3[0]);
    }

    public static MovieImportInfo fromMovieImporterHandle(MovieImporter movieImporter, QTHandleRef qTHandleRef, Movie movie, Track track, int n, int n2) throws QTException {
        int[] nArray = track == null ? null : new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n3 = Track.MovieImportHandle(QTObject.ID(movieImporter), QTObject.ID(qTHandleRef), QTObject.ID(movie), QTObject.ID(track), nArray, n, nArray2, n2, nArray3);
        StdQTException.checkError(n3);
        int n4 = 0;
        if ((n2 & 4) != 0) {
            n4 = track != null ? QTObject.ID(track) : nArray[0];
        }
        Track track2 = n4 == 0 ? null : new Track(n4, movie);
        return new MovieImportInfo(track2, nArray2[0], nArray3[0]);
    }

    public static MovieImportInfo fromMovieImporterDataRef(MovieImporter movieImporter, DataRef dataRef, Movie movie, Track track, int n, int n2) throws QTException {
        int[] nArray = track == null ? null : new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n3 = Track.MovieImportDataRef(QTObject.ID(movieImporter), QTObject.ID(dataRef), dataRef.getType(), QTObject.ID(movie), QTObject.ID(track), nArray, n, nArray2, n2, nArray3);
        StdQTException.checkError(n3);
        int n4 = 0;
        if ((n2 & 4) != 0) {
            n4 = track != null ? QTObject.ID(track) : nArray[0];
        }
        Track track2 = n4 == 0 ? null : new Track(n4, movie);
        return new MovieImportInfo(track2, nArray2[0], nArray3[0]);
    }

    Track(Movie movie, float f, float f2, float f3) throws QTException {
        this(Track.NewMovieTrack(QTObject.ID(movie), QTUtils.X2Fix(f), QTUtils.X2Fix(f2), QTUtils.X2ShortFix(f3)), movie);
        StdQTException.checkError(Track.GetMoviesError());
    }

    Track(int n, Object object) throws QTException {
        super(n, object);
        if (n == 0) {
            throw new StdQTException(-2009);
        }
        this.owner = object;
    }

    void _setNR(int n) {
        this.setNR(n);
    }

    public Media getMedia() throws QTException {
        return Media.getTrackMedia(this);
    }

    public void removeMedia() throws StdQTException {
        int n = Track.GetTrackMedia(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        Track.DisposeTrackMedia(n);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public void setGWorld(QDGraphics qDGraphics, GDevice gDevice) throws StdQTException {
        Track.SetTrackGWorld(this._ID(), QTObject.ID(qDGraphics), QTObject.ID(gDevice), 0, 0);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public Pict getPict(int n) throws QTException {
        return Pict.fromTrack(this, n);
    }

    public Region getClipRgn() throws QTException {
        return Region.fromTrackClip(this);
    }

    public void setClipRgn(Region region) throws StdQTException {
        Track.SetTrackClipRgn(this._ID(), QTObject.ID(region));
        StdQTException.checkError(Track.GetMoviesError());
    }

    public Region getDisplayBoundsRgn() throws QTException {
        return Region.fromTrackDisplay(this);
    }

    public Region getMovieBoundsRgn() throws QTException {
        return Region.fromTrackMovieBounds(this);
    }

    public Region getBoundsRgn() throws QTException {
        return Region.fromTrackBounds(this);
    }

    public int getID() throws StdQTException {
        int n = Track.GetTrackID(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n;
    }

    public int getCreationTime() throws StdQTException {
        int n = Track.GetTrackCreationTime(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n;
    }

    public int getModificationTime() throws StdQTException {
        int n = Track.GetTrackModificationTime(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n;
    }

    public boolean getEnabled() throws StdQTException {
        byte by = Track.GetTrackEnabled(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return by == 1;
    }

    public void setEnabled(boolean bl) throws StdQTException {
        byte by = (byte)(bl ? 1 : 0);
        Track.SetTrackEnabled(this._ID(), by);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public int getUsage() throws StdQTException {
        int n = Track.GetTrackUsage(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n;
    }

    public void setUsage(int n) throws StdQTException {
        Track.SetTrackUsage(this._ID(), n);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public int getDuration() throws StdQTException {
        int n = Track.GetTrackDuration(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n;
    }

    public int getOffset() throws StdQTException {
        int n = Track.GetTrackOffset(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n;
    }

    public void setOffset(int n) throws StdQTException {
        Track.SetTrackOffset(this._ID(), n);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public int getLayer() throws StdQTException {
        short s = Track.GetTrackLayer(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return s;
    }

    public void setLayer(int n) throws StdQTException {
        Track.SetTrackLayer(this._ID(), (short)n);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public Track getAlternate() throws QTException {
        int n = Track.GetTrackAlternate(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return new Track(n, this.owner);
    }

    public void setAlternate(Track track) throws StdQTException {
        Track.SetTrackAlternate(this._ID(), QTObject.ID(track));
        StdQTException.checkError(Track.GetMoviesError());
    }

    public float getVolume() throws StdQTException {
        short s = Track.GetTrackVolume(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return QTUtils.ShortFix2X(s);
    }

    public void setVolume(float f) throws StdQTException {
        Track.SetTrackVolume(this._ID(), QTUtils.X2ShortFix(f));
        StdQTException.checkError(Track.GetMoviesError());
    }

    public Matrix getMatrix() throws StdQTException {
        Matrix matrix = new Matrix();
        Track.GetTrackMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(Track.GetMoviesError());
        return matrix;
    }

    public void setMatrix(Matrix matrix) throws StdQTException {
        Track.SetTrackMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(Track.GetMoviesError());
    }

    public Dimension getDimensions() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Track.GetTrackDimensions(this._ID(), nArray, nArray2);
        StdQTException.checkError(Track.GetMoviesError());
        return new Dimension((int)QTUtils.Fix2X(nArray[0]), (int)QTUtils.Fix2X(nArray2[0]));
    }

    public void setDimensions(Dimension dimension) throws StdQTException {
        Track.SetTrackDimensions(this._ID(), QTUtils.X2Fix(dimension.width), QTUtils.X2Fix(dimension.height));
        StdQTException.checkError(Track.GetMoviesError());
    }

    public QDDimension getSize() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Track.GetTrackDimensions(this._ID(), nArray, nArray2);
        StdQTException.checkError(Track.GetMoviesError());
        return new QDDimension(QTUtils.Fix2X(nArray[0]), QTUtils.Fix2X(nArray2[0]));
    }

    public void setSize(QDDimension qDDimension) throws StdQTException {
        Track.SetTrackDimensions(this._ID(), QTUtils.X2Fix(qDDimension.getWidthF()), QTUtils.X2Fix(qDDimension.getHeightF()));
        StdQTException.checkError(Track.GetMoviesError());
    }

    public UserData getUserData() throws StdQTException {
        return UserData.fromTrack(this);
    }

    public String getName() throws StdQTException {
        UserData userData = UserData.fromTrack(this);
        try {
            QTHandle qTHandle = userData.getData(1851878757, 1);
            int n = qTHandle.getSize();
            byte[] byArray = new byte[n];
            qTHandle.copyToArray(0, byArray, 0, n);
            return new String(byArray);
        }
        catch (QTException qTException) {
            int n = qTException.errorCode();
            if (n != -2026) {
                throw new StdQTException(n);
            }
            return new String();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setName(String string) throws QTException {
        UserData userData = UserData.fromTrack(this);
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        if (n == 0) {
            try {
                userData.removeData(1851878757, 1);
                return;
            }
            catch (StdQTException stdQTException) {
                int n2 = stdQTException.errorCode();
                if (n2 == -2026) return;
                throw new StdQTException(n2);
            }
        } else {
            QTHandle qTHandle = new QTHandle(n, false);
            qTHandle.copyFromArray(0, string.getBytes(), 0, n);
            userData.setDataItem(qTHandle.toQTPointer(), 1851878757, 1);
        }
    }

    public Matrix getDisplayMatrix() throws StdQTException {
        Matrix matrix = new Matrix();
        short s = Track.GetTrackDisplayMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(s);
        return matrix;
    }

    public QTHandle getSoundLocalizationSettings() throws QTException {
        return QTHandle.fromTrack(this);
    }

    public void setSoundLocalizationSettings(QTHandle qTHandle) throws StdQTException {
        short s = Track.SetTrackSoundLocalizationSettings(this._ID(), QTObject.ID(qTHandle));
        StdQTException.checkError(s);
    }

    public Movie getMovie() throws StdQTException {
        int n = Track.GetTrackMovie(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n == 0 ? null : new Movie(n, this);
    }

    public TimeInfo getNextInterestingTime(int n, int n2, float f) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Track.GetTrackNextInterestingTime(this._ID(), (short)n, n2, QTUtils.X2Fix(f), nArray, nArray2);
        StdQTException.checkError(Track.GetMoviesError());
        return new TimeInfo(nArray[0], nArray2[0]);
    }

    public void insertMedia(int n, int n2, int n3, float f) throws StdQTException {
        short s = Track.InsertMediaIntoTrack(this._ID(), n, n2, n3, QTUtils.X2Fix(f));
        StdQTException.checkError(s);
    }

    public void insertEmptySegment(int n, int n2) throws StdQTException {
        short s = Track.InsertEmptyTrackSegment(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public void deleteSegment(int n, int n2) throws StdQTException {
        short s = Track.DeleteTrackSegment(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public void scaleSegment(int n, int n2, int n3) throws StdQTException {
        short s = Track.ScaleTrackSegment(this._ID(), n, n2, n3);
        StdQTException.checkError(s);
    }

    public TrackEditState newEditState() throws QTException {
        int n = Track.NewTrackEditState(this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return new TrackEditState(this, n);
    }

    public void useEditState(TrackEditState trackEditState) throws StdQTException {
        short s = Track.UseTrackEditState(this._ID(), QTObject.ID(trackEditState));
        StdQTException.checkError(s);
    }

    public int addReference(Track track, int n) throws StdQTException {
        int[] nArray = new int[1];
        short s = Track.AddTrackReference(this._ID(), QTObject.ID(track), n, nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public void deleteReference(int n, int n2) throws StdQTException {
        short s = Track.DeleteTrackReference(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public void setReference(Track track, int n, int n2) throws StdQTException {
        short s = Track.SetTrackReference(this._ID(), QTObject.ID(track), n, n2);
        StdQTException.checkError(s);
    }

    public Track getReference(int n, int n2) throws QTException {
        int n3 = Track.GetTrackReference(this._ID(), n, n2);
        StdQTException.checkError(Track.GetMoviesError());
        return new Track(n3, this.owner);
    }

    public int getNextReferenceType(int n) throws StdQTException {
        int n2 = Track.GetNextTrackReferenceType(this._ID(), n);
        StdQTException.checkError(Track.GetMoviesError());
        return n2;
    }

    public int getReferenceCount(int n) throws StdQTException {
        int n2 = Track.GetTrackReferenceCount(this._ID(), n);
        StdQTException.checkError(Track.GetMoviesError());
        return n2;
    }

    public int trackTimeToMediaTime(int n) throws StdQTException {
        int n2 = Track.TrackTimeToMediaTime(n, this._ID());
        StdQTException.checkError(Track.GetMoviesError());
        return n2;
    }

    public float getEditRate(int n) throws StdQTException {
        int n2 = Track.GetTrackEditRate(this._ID(), n);
        StdQTException.checkError(Track.GetMoviesError());
        return QTUtils.Fix2X(n2);
    }

    public int getDataSize(int n, int n2) throws StdQTException {
        int n3 = Track.GetTrackDataSize(this._ID(), n, n2);
        StdQTException.checkError(Track.GetMoviesError());
        return n3;
    }

    public boolean pointInMovie(QDPoint qDPoint) throws StdQTException {
        byte by = Track.PtInTrack(this._ID(), qDPoint.getPoint());
        StdQTException.checkError(Track.GetMoviesError());
        return by == 1;
    }

    public Region getSegmentDisplayBoundsRgn(int n, int n2) throws QTException {
        return Region.fromTrackSegment(this, n, n2);
    }

    public int getStatus() {
        int n = Track.GetTrackStatus(this._ID());
        return n;
    }

    public void setLoadSettings(LoadSettings loadSettings) throws StdQTException {
        Track.SetTrackLoadSettings(this._ID(), loadSettings.time, loadSettings.duration, loadSettings.preloadFlags, loadSettings.defaultHints);
        StdQTException.checkError(Track.GetMoviesError());
    }

    public LoadSettings getLoadSettings() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        Track.GetTrackLoadSettings(this._ID(), nArray, nArray2, nArray3, nArray4);
        StdQTException.checkError(Track.GetMoviesError());
        return new LoadSettings(nArray[0], nArray2[0], nArray3[0], nArray4[0]);
    }

    public void insertSegment(Track track, int n, int n2, int n3) throws StdQTException {
        short s = Track.InsertTrackSegment(this._ID(), QTObject.ID(track), n, n2, n3);
        StdQTException.checkError(s);
    }

    public void copySettings(Track track) throws StdQTException {
        short s = Track.CopyTrackSettings(this._ID(), QTObject.ID(track));
        StdQTException.checkError(s);
    }

    public void loadIntoRam(int n, int n2, int n3) throws StdQTException {
        short s = Track.LoadTrackIntoRam(this._ID(), n, n2, n3);
        StdQTException.checkError(s);
    }

    public MovieImporter isScrapMovie() throws StdQTException {
        return MovieImporter.fromTrack(this);
    }

    public PixMap getMatte() throws StdQTException {
        return PixMap.fromTrack(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMatte(PixMap pixMap) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            Track.SetTrackMatte(this._ID(), QTObject.ID(pixMap));
            StdQTException.checkError(Track.GetMoviesError());
        }
    }

    public void copyUserDataToTrack(Track track, boolean bl) throws StdQTException {
        StdQTException.checkError(Track.CopyTrackUserData(this._ID(), QTObject.ID(track), bl ? 1919970403 : 1835361639));
    }

    public void copyUserDataFromTrack(Track track, boolean bl) throws StdQTException {
        StdQTException.checkError(Track.CopyTrackUserData(QTObject.ID(track), this._ID(), bl ? 1919970403 : 1835361639));
    }

    public static void copyUserData(Track track, Track track2, int n) throws StdQTException {
        StdQTException.checkError(Track.CopyTrackUserData(QTObject.ID(track), QTObject.ID(track2), n));
    }

    public String toString() {
        try {
            return super.toString() + "[ID=" + this.getID() + "]";
        }
        catch (StdQTException stdQTException) {
            return super.toString() + "[ID=unable to obtain track ID]";
        }
    }

    private static native int GetMediaTrack(int var0);

    private static native short GetMoviesError();

    private static native int MovieImportFile(int var0, byte[] var1, int var2, int var3, int[] var4, int var5, int[] var6, int var7, int[] var8);

    private static native int MovieImportHandle(int var0, int var1, int var2, int var3, int[] var4, int var5, int[] var6, int var7, int[] var8);

    private static native int MovieImportDataRef(int var0, int var1, int var2, int var3, int var4, int[] var5, int var6, int[] var7, int var8, int[] var9);

    private static native int NewMovieTrack(int var0, int var1, int var2, short var3);

    private static native int GetTrackMedia(int var0);

    private static native void DisposeTrackMedia(int var0);

    private static native void SetTrackGWorld(int var0, int var1, int var2, int var3, int var4);

    private static native void SetTrackClipRgn(int var0, int var1);

    private static native int GetTrackID(int var0);

    private static native int GetTrackCreationTime(int var0);

    private static native int GetTrackModificationTime(int var0);

    private static native byte GetTrackEnabled(int var0);

    private static native void SetTrackEnabled(int var0, byte var1);

    private static native int GetTrackUsage(int var0);

    private static native void SetTrackUsage(int var0, int var1);

    private static native int GetTrackDuration(int var0);

    private static native int GetTrackOffset(int var0);

    private static native void SetTrackOffset(int var0, int var1);

    private static native short GetTrackLayer(int var0);

    private static native void SetTrackLayer(int var0, short var1);

    private static native int GetTrackAlternate(int var0);

    private static native void SetTrackAlternate(int var0, int var1);

    private static native short GetTrackVolume(int var0);

    private static native void SetTrackVolume(int var0, short var1);

    private static native void GetTrackMatrix(int var0, byte[] var1);

    private static native void SetTrackMatrix(int var0, byte[] var1);

    private static native void GetTrackDimensions(int var0, int[] var1, int[] var2);

    private static native void SetTrackDimensions(int var0, int var1, int var2);

    private static native short GetTrackDisplayMatrix(int var0, byte[] var1);

    private static native short SetTrackSoundLocalizationSettings(int var0, int var1);

    private static native int GetTrackMovie(int var0);

    private static native void GetTrackNextInterestingTime(int var0, short var1, int var2, int var3, int[] var4, int[] var5);

    private static native short InsertMediaIntoTrack(int var0, int var1, int var2, int var3, int var4);

    private static native short InsertEmptyTrackSegment(int var0, int var1, int var2);

    private static native short DeleteTrackSegment(int var0, int var1, int var2);

    private static native short ScaleTrackSegment(int var0, int var1, int var2, int var3);

    private static native int NewTrackEditState(int var0);

    private static native short UseTrackEditState(int var0, int var1);

    private static native short AddTrackReference(int var0, int var1, int var2, int[] var3);

    private static native short DeleteTrackReference(int var0, int var1, int var2);

    private static native short SetTrackReference(int var0, int var1, int var2, int var3);

    private static native int GetTrackReference(int var0, int var1, int var2);

    private static native int GetNextTrackReferenceType(int var0, int var1);

    private static native int GetTrackReferenceCount(int var0, int var1);

    private static native int TrackTimeToMediaTime(int var0, int var1);

    private static native int GetTrackEditRate(int var0, int var1);

    private static native int GetTrackDataSize(int var0, int var1, int var2);

    private static native byte PtInTrack(int var0, int var1);

    private static native int GetTrackStatus(int var0);

    private static native void SetTrackLoadSettings(int var0, int var1, int var2, int var3, int var4);

    private static native void GetTrackLoadSettings(int var0, int[] var1, int[] var2, int[] var3, int[] var4);

    private static native short InsertTrackSegment(int var0, int var1, int var2, int var3, int var4);

    private static native short CopyTrackSettings(int var0, int var1);

    private static native short LoadTrackIntoRam(int var0, int var1, int var2, int var3);

    private static native void SetTrackMatte(int var0, int var1);

    private static native short CopyTrackUserData(int var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$movies$Track == null ? (class$quicktime$std$movies$Track = Track.class$("quicktime.std.movies.Track")) : class$quicktime$std$movies$Track);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

