/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies;

import quicktime.QTException;
import quicktime.qd.QDColor;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.std.image.Matrix;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class TweenData
extends QTByteObject {
    public static final int kQDPointNativeSize = 4;
    public static final int kQDRectNativeSize = 8;
    public static final int kRGBNativeSize = 6;
    public static final int kModifierTrackGraphicsModeNativeSize = 10;
    public static final int kMatrixNativeSize = 36;
    public static final int kFixedPointNativeSize = 8;
    public static final int kQTFloatDoubleNativeSize = 8;
    private int type;

    public TweenData(short s, short s2) throws QTException {
        super(TweenData.allocSize(1));
        this.type = 1;
        this.setShortAt(0, s);
        this.setShortAt(2, s2);
    }

    public TweenData(int n, int n2) throws QTException {
        super(TweenData.allocSize(2));
        this.type = 2;
        this.setIntAt(0, n);
        this.setIntAt(4, n2);
    }

    public TweenData(int n, float f, float f2) throws QTException {
        super(TweenData.allocSize(n));
        this.type = n;
        switch (this.type) {
            case 3: {
                this.setIntAt(0, QTUtils.X2Fix(f));
                this.setIntAt(4, QTUtils.X2Fix(f2));
                break;
            }
            case 10: {
                this.setFloatAt(0, f);
                this.setFloatAt(4, f2);
            }
        }
    }

    public TweenData(double d, double d2) throws QTException {
        super(TweenData.allocSize(11));
        this.type = 11;
        this.setDoubleAt(0, d);
        this.setDoubleAt(8, d2);
    }

    public TweenData(QDPoint qDPoint, QDPoint qDPoint2) throws QTException {
        super(TweenData.allocSize(4));
        this.type = 4;
        this.setIntAt(0, qDPoint.getPoint());
        this.setIntAt(4, qDPoint2.getPoint());
    }

    public TweenData(QDRect qDRect, QDRect qDRect2) throws QTException {
        super(TweenData.allocSize(5));
        this.type = 5;
        this.setBytesAt(0, 8, qDRect.getBytes(), 0);
        this.setBytesAt(8, 8, qDRect2.getBytes(), 0);
    }

    public TweenData(Matrix matrix, Matrix matrix2) throws QTException {
        super(TweenData.allocSize(7));
        this.type = 7;
        this.setBytesAt(0, 36, matrix.getBytes(), 0);
        this.setBytesAt(36, 36, matrix2.getBytes(), 0);
    }

    public TweenData(QDColor qDColor, QDColor qDColor2) throws QTException {
        super(TweenData.allocSize(8));
        this.type = 8;
        this.setBytesAt(0, 6, qDColor.getBytes(), 0);
        this.setBytesAt(6, 6, qDColor2.getBytes(), 0);
    }

    public TweenData(QDColor qDColor, QDColor qDColor2, int n) throws QTException {
        super(TweenData.allocSize(9));
        this.type = 9;
        this.setIntAt(0, n);
        this.setBytesAt(4, 6, qDColor.getBytes(), 0);
        this.setIntAt(10, n);
        this.setBytesAt(14, 6, qDColor2.getBytes(), 0);
    }

    public TweenData(float f, float f2, float f3, float f4) throws QTException {
        super(TweenData.allocSize(12));
        this.type = 12;
        this.setFloatAt(0, f);
        this.setFloatAt(4, f2);
        this.setFloatAt(8, f3);
        this.setFloatAt(12, f4);
    }

    public int getType() {
        return this.type;
    }

    private static int allocSize(int n) throws QTException {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            case 7: {
                n2 = 36;
                break;
            }
            case 8: {
                n2 = 6;
                break;
            }
            case 9: {
                n2 = 10;
                break;
            }
            case 11: {
                n2 = 8;
                break;
            }
            case 12: {
                n2 = 8;
            }
        }
        if (n2 == 0) {
            throw new QTException("unsupported tween type");
        }
        return n2 + n2;
    }
}

