/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;

public final class MusicMIDIPacket
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 255;
    static final long serialVersionUID = -3977273754888819406L;
    static /* synthetic */ Class class$quicktime$std$music$MusicMIDIPacket;

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[255];
        objectInputStream.read(this.getBytes());
        MusicMIDIPacket.setShortInArray(this.getBytes(), 0, EndianOrder.flipBigEndianToNative16(MusicMIDIPacket.getShortFromArray(this.getBytes(), 0)));
        MusicMIDIPacket.setIntInArray(this.getBytes(), 2, EndianOrder.flipBigEndianToNative32(MusicMIDIPacket.getIntFromArray(this.getBytes(), 2)));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[255];
        System.arraycopy(this.getBytes(), 0, byArray, 0, 255);
        MusicMIDIPacket.setShortInArray(byArray, 0, EndianOrder.flipNativeToBigEndian16(MusicMIDIPacket.getShortFromArray(this.getBytes(), 0)));
        MusicMIDIPacket.setIntInArray(byArray, 2, EndianOrder.flipNativeToBigEndian32(MusicMIDIPacket.getIntFromArray(this.getBytes(), 2)));
        objectOutputStream.write(byArray);
    }

    public MusicMIDIPacket() {
        super(255);
    }

    public MusicMIDIPacket(byte[] byArray) {
        this();
        this.setMIDIData(byArray);
    }

    public byte[] getMIDIData() {
        short s = this.getShortAt(0);
        byte[] byArray = new byte[s];
        this.getBytesAt(6, s, byArray, 0);
        return byArray;
    }

    public void setMIDIData(byte[] byArray) {
        int n = byArray.length > 249 ? 249 : byArray.length;
        this.setShortAt(0, (short)n);
        this.setIntAt(2, 0);
        this.setBytesAt(6, n, byArray, 0);
    }

    public void setDataByte(int n, int n2) {
        if (n < this.getShortAt(0)) {
            this.setByteAt(n + 6, (byte)n2);
        }
    }

    public int getReserved() {
        return this.getIntAt(2);
    }

    public String toString() {
        return this.getClass().getName() + "[length=" + (this.getShortAt(0) - 6) + "]";
    }

    public Object clone() {
        return new MusicMIDIPacket(this.bytes);
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$music$MusicMIDIPacket == null ? (class$quicktime$std$music$MusicMIDIPacket = MusicMIDIPacket.class$("quicktime.std.music.MusicMIDIPacket")) : class$quicktime$std$music$MusicMIDIPacket);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

