/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.io.QTFile;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTPointer;
import quicktime.util.QTUtils;

public class SynthesizerConnections
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 32;
    private QTPointer spec;
    private static final long serialVersionUID = -2499879404792104283L;
    static /* synthetic */ Class class$quicktime$std$music$SynthesizerConnections;

    public SynthesizerConnections() {
        this(32);
    }

    public SynthesizerConnections(QTFile qTFile) throws QTException {
        this();
        this.setSoundBankFile(qTFile);
    }

    protected SynthesizerConnections(int n) {
        super(n);
    }

    protected SynthesizerConnections(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        this.bytes = new byte[n];
        objectInputStream.read(this.bytes);
        for (int i = 0; i < 32; i += 4) {
            SynthesizerConnections.setIntInArray(this.bytes, i, EndianOrder.flipBigEndianToNative32(SynthesizerConnections.getIntFromArray(this.bytes, i)));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        int n = this.getSize();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < 32; i += 2) {
            SynthesizerConnections.setIntInArray(byArray, i, EndianOrder.flipNativeToBigEndian32(SynthesizerConnections.getIntFromArray(this.getBytes(), i)));
        }
        objectOutputStream.write(byArray);
    }

    public void setSoundBankFile(QTFile qTFile) throws QTException {
        byte[] byArray = qTFile.getFSSpec(true, 256);
        this.spec = new QTPointer(byArray);
        this.setIntAt(24, QTObject.ID(this.spec));
    }

    public QTFile getSoundBankFile() throws QTException {
        return QTFile.fromSynthesizerConnections(this);
    }

    public final int getClientID() {
        return this.getIntAt(0);
    }

    public final void setClientID(int n) {
        this.setIntAt(0, n);
    }

    public final int getInputID() {
        return this.getIntAt(8);
    }

    public final void setInputID(int n) {
        this.setIntAt(8, n);
    }

    public final int getOutputID() {
        return this.getIntAt(4);
    }

    public final void setOutputID(int n) {
        this.setIntAt(4, n);
    }

    public final int getMIDIChannel() {
        return this.getIntAt(12);
    }

    public final void setMIDIChannel(int n) {
        this.setIntAt(12, n);
    }

    public final int getFlags() {
        return this.getIntAt(16);
    }

    public final void setFlags(int n) {
        this.setIntAt(16, n);
    }

    public final int getUniqueID() {
        return this.getIntAt(20);
    }

    public final void setUniqueID(int n) {
        this.setIntAt(20, n);
    }

    public String toString() {
        return this.getClass().getName() + "[flags=" + this.getFlags() + (this.getFlags() > 0 ? ",clientID=" + QTUtils.fromOSType(this.getClientID()) + ",inputID=" + QTUtils.fromOSType(this.getInputID()) + ",outputID=" + QTUtils.fromOSType(this.getOutputID()) + ",uniqueID=" + QTUtils.fromOSType(this.getUniqueID()) + "]" : "]") + "";
    }

    public Object clone() {
        return new SynthesizerConnections(this.bytes);
    }

    private static native short getShortFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setShortInArray(byte[] var0, int var1, short var2);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$std$music$SynthesizerConnections == null ? (class$quicktime$std$music$SynthesizerConnections = SynthesizerConnections.class$("quicktime.std.music.SynthesizerConnections")) : class$quicktime$std$music$SynthesizerConnections);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

