/*
 * Decompiled with CFR 0.152.
 */
package quicktime.streaming;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.streaming.EditList;
import quicktime.streaming.MediaParams;
import quicktime.streaming.StreamDispatcher;
import quicktime.streaming.StreamNotifyProc;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class NewPresentationParams
extends QTPointerRef {
    public static final int kNativeSize = 36;
    private StreamDispatcher notifyUPP;
    private QTPointer data = null;
    private EditList el = null;

    NewPresentationParams() throws QTException {
        super(36, true);
    }

    public NewPresentationParams(int n, QTPointer qTPointer, EditList editList) throws QTException {
        super(36, true);
        this.setDataType(n);
        this.setData(qTPointer);
        this.setEditList(editList);
    }

    public void setDataType(int n) {
        this.setIntAt(0, n);
    }

    public int getDataType() {
        return this.getIntAt(0);
    }

    public void setData(QTPointer qTPointer) {
        this.setIntAt(4, QTObject.ID(qTPointer));
        this.setIntAt(8, qTPointer.getSize());
        this.data = qTPointer;
    }

    public QTPointer getData() {
        return this.data;
    }

    private void setEditList(EditList editList) {
        this.setIntAt(12, QTObject.ID(editList));
        this.el = editList;
    }

    public EditList getEditList() {
        return this.el;
    }

    public void setFlags(int n) {
        this.setIntAt(16, n);
    }

    public int getFlags() {
        return this.getIntAt(16);
    }

    public void setTimeScale(int n) {
        this.setIntAt(20, n);
    }

    public int getTimeScale() {
        return this.getIntAt(20);
    }

    public void setMediaParams(MediaParams mediaParams) {
        this.setIntAt(24, QTObject.ID(mediaParams));
    }

    public void setNotificationProc(StreamNotifyProc streamNotifyProc) {
        if (streamNotifyProc == null) {
            this.setIntAt(28, 0);
            this.notifyUPP.cleanup();
            this.notifyUPP = null;
        } else {
            this.notifyUPP = new StreamDispatcher(streamNotifyProc);
            this.setIntAt(28, this.notifyUPP.ID());
        }
    }

    public String toString() {
        return this.getClass().getName() + "[dataType=" + QTUtils.fromOSType(this.getDataType()) + ",data=" + this.getData() + ",editList" + this.getEditList() + ",flags" + this.getFlags() + ",timeScale" + this.getTimeScale() + "]";
    }

    static {
        if (QTSession.hasSecurityRestrictions()) {
            throw new SecurityException("Only able to broadcast with security settings when class is signed");
        }
        if (QTSession.isCurrentOS(2)) {
            throw new RuntimeException("The broadcaster API is not supported on windows");
        }
    }
}

