/*
 * Decompiled with CFR 0.152.
 */
package quicktime.streaming;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QTStreamingLib;
import quicktime.qd.GDevice;
import quicktime.qd.Pict;
import quicktime.qd.QDColor;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.Region;
import quicktime.std.clocks.TimeBase;
import quicktime.std.comp.Component;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.Matrix;
import quicktime.std.movies.media.DataRef;
import quicktime.streaming.ExportParams;
import quicktime.streaming.NewPresentationParams;
import quicktime.streaming.PresIdleParams;
import quicktime.streaming.PresParams;
import quicktime.streaming.Sourcer;
import quicktime.streaming.Stream;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class Presentation
extends QTObject
implements QTStreamingLib {
    private static Object linkage;
    private static Object owner;
    static /* synthetic */ Class class$quicktime$streaming$Presentation;

    Presentation(int n, Object object) {
        super(n, object);
    }

    private Presentation(int n) {
        super(n, null);
    }

    public Presentation(NewPresentationParams newPresentationParams) throws QTException {
        super(Presentation.allocate(newPresentationParams));
    }

    private static int allocate(NewPresentationParams newPresentationParams) throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSNewPresentation(QTObject.ID(newPresentationParams), nArray));
        return nArray[0];
    }

    public static Presentation fromData(int n, QTPointerRef qTPointerRef, PresParams presParams) throws QTException {
        long[] lArray = new long[]{qTPointerRef.getSize()};
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSNewPresentationFromData(n, QTObject.ID(qTPointerRef), lArray, QTObject.ID(presParams), nArray));
        return new Presentation(nArray[0]);
    }

    public static Presentation fromFile(QTFile qTFile, PresParams presParams) throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSNewPresentationFromFile(qTFile.getFSSpec(true, 256), QTObject.ID(presParams), nArray));
        return new Presentation(nArray[0]);
    }

    public static Presentation fromDataRef(DataRef dataRef, PresParams presParams) throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSNewPresentationFromDataRef(QTObject.ID(dataRef), dataRef.getType(), QTObject.ID(presParams), nArray));
        return new Presentation(nArray[0]);
    }

    public void export(ExportParams exportParams) throws QTException {
        QTException.checkError(Presentation.QTSPresExport(this._ID(), 0, exportParams.getBytes()));
    }

    public void export(ExportParams exportParams, Stream stream) throws QTException {
        QTException.checkError(Presentation.QTSPresExport(this._ID(), QTObject.ID(stream), exportParams.getBytes()));
    }

    public void setFlags(int n, int n2) throws QTException {
        QTException.checkError(Presentation.QTSPresSetFlags(this._ID(), n, n2));
    }

    public int getFlags() throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetFlags(this._ID(), nArray));
        return nArray[0];
    }

    public TimeBase getTimeBase() throws QTException {
        return TimeBase.fromPresentation(this);
    }

    public int getTimeScale() throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetTimeScale(this._ID(), nArray));
        return nArray[0];
    }

    private void setInfo(int n, byte[] byArray) throws QTException {
        QTException.checkError(Presentation.QTSPresSetInfo(this._ID(), 0, n, byArray));
    }

    private void setInfo(Stream stream, int n, byte[] byArray) throws QTException {
        QTException.checkError(Presentation.QTSPresSetInfo(this._ID(), QTObject.ID(stream), n, byArray));
    }

    private byte[] getInfo(int n) throws QTException {
        byte[] byArray = new byte[]{0};
        QTException.checkError(Presentation.QTSPresGetInfo(this._ID(), 0, n, byArray));
        return byArray;
    }

    private byte[] getInfo(Stream stream, int n) throws QTException {
        byte[] byArray = new byte[]{0};
        QTException.checkError(Presentation.QTSPresGetInfo(this._ID(), QTObject.ID(stream), n, byArray));
        return byArray;
    }

    public int getTotalDataRate() throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetInfo(this._ID(), 0, 1685222516, nArray));
        return nArray[0];
    }

    public boolean hasCharacteristic(Stream stream, int n) throws QTException {
        byte[] byArray = new byte[]{0};
        QTException.checkError(Presentation.QTSPresHasCharacteristic(this._ID(), QTObject.ID(stream), n, byArray));
        return byArray[0] != 0;
    }

    public void preview() throws QTException {
        this.preview(0L, 65536.0f, 0);
    }

    public void preview(long l, float f, int n) throws QTException {
        long[] lArray = new long[]{l};
        QTException.checkError(Presentation.QTSPresPreview(this._ID(), 0, lArray, QTUtils.X2Fix(f), n));
    }

    public void preview(Stream stream, long l, float f, int n) throws QTException {
        long[] lArray = new long[]{l};
        QTException.checkError(Presentation.QTSPresPreview(this._ID(), QTObject.ID(stream), lArray, QTUtils.X2Fix(f), n));
    }

    public void preroll() throws QTException {
        this.preroll(0, 65536.0f, 0);
    }

    public void preroll(int n, float f, int n2) throws QTException {
        QTException.checkError(Presentation.QTSPresPreroll(this._ID(), 0, n, QTUtils.X2Fix(f), n2));
    }

    public void preroll(Stream stream, int n, float f, int n2) throws QTException {
        QTException.checkError(Presentation.QTSPresPreroll(this._ID(), QTObject.ID(stream), n, QTUtils.X2Fix(f), n2));
    }

    public void preroll(Stream stream, long l, float f, int n) throws QTException {
        long[] lArray = new long[]{l};
        QTException.checkError(Presentation.QTSPresPreroll64(this._ID(), QTObject.ID(stream), lArray, QTUtils.X2Fix(f), n));
    }

    public void start() throws QTException {
        this.start(0);
    }

    public void start(int n) throws QTException {
        Presentation.QTSPresStart(this._ID(), 0, n);
    }

    public void start(Stream stream, int n) throws QTException {
        QTException.checkError(Presentation.QTSPresStart(this._ID(), QTObject.ID(stream), n));
    }

    public void idle(PresIdleParams presIdleParams) {
        Presentation.QTSPresIdle(this._ID(), QTObject.ID(presIdleParams));
    }

    public void invalidateRegion(Region region) throws QTException {
        QTException.checkError(Presentation.QTSPresInvalidateRegion(this._ID(), QTObject.ID(region)));
    }

    public void skipTo(int n) throws QTException {
        QTException.checkError(Presentation.QTSPresSkipTo(this._ID(), n));
    }

    public void skipTo(long l) throws QTException {
        long[] lArray = new long[]{l};
        QTException.checkError(Presentation.QTSPresSkipTo64(this._ID(), lArray));
    }

    public void stop() throws QTException {
        QTException.checkError(Presentation.QTSPresStop(this._ID(), 0, 0));
    }

    public void stop(Stream stream, int n) throws QTException {
        QTException.checkError(Presentation.QTSPresStop(this._ID(), QTObject.ID(stream), n));
    }

    public int getNumStreams() {
        return Presentation.QTSPresGetNumStreams(this._ID());
    }

    public Stream getIndStream(int n) throws QTException {
        int n2 = Presentation.QTSPresGetIndStream(this._ID(), n);
        return new Stream(n2, this);
    }

    public void setPreferredRate(float f, int n) throws QTException {
        QTException.checkError(Presentation.QTSPresSetPreferredRate(this._ID(), QTUtils.X2Fix(f), n));
    }

    public float getPreferredRate() throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetPreferredRate(this._ID(), nArray));
        return QTUtils.Fix2X(nArray[0]);
    }

    public void setEnable(Stream stream, boolean bl) throws QTException {
        QTException.checkError(Presentation.QTSPresSetEnable(this._ID(), QTObject.ID(stream), bl ? (byte)1 : 0));
    }

    public boolean getEnable(Stream stream) throws QTException {
        byte[] byArray = new byte[]{0};
        QTException.checkError(Presentation.QTSPresGetEnable(this._ID(), QTObject.ID(stream), byArray));
        return byArray[0] != 0;
    }

    public void setPresenting(Stream stream, boolean bl) throws QTException {
        QTException.checkError(Presentation.QTSPresSetPresenting(this._ID(), QTObject.ID(stream), bl ? (byte)1 : 0));
    }

    public boolean getPresenting(Stream stream) throws QTException {
        byte[] byArray = new byte[]{0};
        QTException.checkError(Presentation.QTSPresGetPresenting(this._ID(), QTObject.ID(stream), byArray));
        return byArray[0] != 0;
    }

    public void setActiveSegment(Stream stream, long l, long l2) throws QTException {
        long[] lArray = new long[]{l};
        long[] lArray2 = new long[]{l2};
        QTException.checkError(Presentation.QTSPresSetActiveSegment(this._ID(), QTObject.ID(stream), lArray, lArray2));
    }

    public long getActiveSegmentStart(Stream stream) throws QTException {
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        QTException.checkError(Presentation.QTSPresGetActiveSegment(this._ID(), QTObject.ID(stream), lArray, lArray2));
        return lArray[0];
    }

    public long getActiveSegmentDuration(Stream stream) throws QTException {
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        QTException.checkError(Presentation.QTSPresGetActiveSegment(this._ID(), QTObject.ID(stream), lArray, lArray2));
        return lArray2[0];
    }

    public void setPlayHints(Stream stream, int n, int n2) throws QTException {
        QTException.checkError(Presentation.QTSPresSetPlayHints(this._ID(), QTObject.ID(stream), n, n2));
    }

    public int getPlayHints(Stream stream) throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetPlayHints(this._ID(), QTObject.ID(stream), nArray));
        return nArray[0];
    }

    public void setGWorld(Stream stream, QDGraphics qDGraphics, GDevice gDevice) throws QTException {
        QTException.checkError(Presentation.QTSPresSetGWorld(this._ID(), QTObject.ID(stream), QTObject.ID(qDGraphics), QTObject.ID(gDevice)));
    }

    public void setGWorld(Stream stream, QDGraphics qDGraphics) throws QTException {
        this.setGWorld(stream, qDGraphics, GDevice.getMain());
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        QTException.checkError(Presentation.QTSPresSetGWorld(this._ID(), 0, QTObject.ID(qDGraphics), QTObject.ID(GDevice.getMain())));
    }

    public QDGraphics getGWorld(Stream stream) throws QTException {
        return QDGraphics.fromPresentation(this, stream);
    }

    public QDGraphics getGWorld() throws QTException {
        return QDGraphics.fromPresentation(this, null);
    }

    public void setClip(Stream stream, Region region) throws QTException {
        QTException.checkError(Presentation.QTSPresSetClip(this._ID(), QTObject.ID(stream), QTObject.ID(region)));
    }

    public Region getClip(Stream stream) throws QTException {
        return Region.fromPresentationClip(this, stream);
    }

    public void setMatrix(Stream stream, Matrix matrix) throws QTException {
        QTException.checkError(Presentation.QTSPresSetMatrix(this._ID(), QTObject.ID(stream), matrix.getBytes()));
    }

    public Matrix getMatrix(Stream stream) throws QTException {
        Matrix matrix = new Matrix();
        QTException.checkError(Presentation.QTSPresSetMatrix(this._ID(), QTObject.ID(stream), matrix.getBytes()));
        return matrix;
    }

    public void setDimensions(Stream stream, float f, float f2) throws QTException {
        QTException.checkError(Presentation.QTSPresSetDimensions(this._ID(), QTObject.ID(stream), QTUtils.X2Fix(f), QTUtils.X2Fix(f2)));
    }

    public void setDimensions(Stream stream, QDDimension qDDimension) throws QTException {
        this.setDimensions(stream, qDDimension.getWidthF(), qDDimension.getHeightF());
    }

    public QDDimension getDimensions(Stream stream) throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetDimensions(this._ID(), QTObject.ID(stream), nArray, nArray2));
        return new QDDimension(QTUtils.Fix2X(nArray[0]), QTUtils.Fix2X(nArray2[0]));
    }

    public void setGraphicsMode(Stream stream, int n, QDColor qDColor) throws QTException {
        QTException.checkError(Presentation.QTSPresSetGraphicsMode(this._ID(), QTObject.ID(stream), (short)n, qDColor.getRGBColor()));
    }

    public GraphicsMode getGraphicsMode(Stream stream) throws QTException {
        byte[] byArray = new byte[]{0};
        short[] sArray = new short[]{0};
        QTException.checkError(Presentation.QTSPresGetGraphicsMode(this._ID(), QTObject.ID(stream), sArray, byArray));
        return new GraphicsMode(sArray[0], QDColor.fromArray(byArray, 6));
    }

    public Pict getPicture(Stream stream) throws QTException {
        return Pict.fromPresentation(this, stream);
    }

    public void setVolumes(Stream stream, int n, int n2) throws QTException {
        QTException.checkError(Presentation.QTSPresSetVolumes(this._ID(), QTObject.ID(stream), (short)n, (short)n2));
    }

    public int getRightVolume(Stream stream) throws QTException {
        short[] sArray = new short[]{0};
        short[] sArray2 = new short[]{0};
        QTException.checkError(Presentation.QTSPresGetVolumes(this._ID(), QTObject.ID(stream), sArray, sArray2));
        return sArray2[0];
    }

    public int getLeftVolume(Stream stream) throws QTException {
        short[] sArray = new short[]{0};
        short[] sArray2 = new short[]{0};
        QTException.checkError(Presentation.QTSPresGetVolumes(this._ID(), QTObject.ID(stream), sArray, sArray2));
        return sArray[0];
    }

    public void addSource(Stream stream, Component component, int n) throws QTException {
        this.addSourcer(stream, (Sourcer)component, n);
    }

    public void removeSource(Stream stream, Component component, int n) throws QTException {
        this.removeSourcer(stream, (Sourcer)component, n);
    }

    public void addSourcer(Stream stream, Sourcer sourcer, int n) throws QTException {
        QTException.checkError(Presentation.QTSPresAddSourcer(this._ID(), QTObject.ID(stream), QTObject.ID(sourcer), n));
    }

    public void removeSourcer(Stream stream, Sourcer sourcer, int n) throws QTException {
        QTException.checkError(Presentation.QTSPresRemoveSourcer(this._ID(), QTObject.ID(stream), QTObject.ID(sourcer), n));
    }

    public int getNumSources(Stream stream) {
        return this.getNumSourcers(stream);
    }

    public int getNumSourcers(Stream stream) {
        return Presentation.QTSPresGetNumSourcers(this._ID(), QTObject.ID(stream));
    }

    public Sourcer getIndSourcer(Stream stream, int n) throws QTException {
        int[] nArray = new int[]{0};
        QTException.checkError(Presentation.QTSPresGetIndSourcer(this._ID(), QTObject.ID(stream), n, nArray));
        return new Sourcer(nArray[0]);
    }

    private static native short QTSNewPresentation(int var0, int[] var1);

    private static native short QTSNewPresentationFromData(int var0, int var1, long[] var2, int var3, int[] var4);

    private static native short QTSNewPresentationFromFile(byte[] var0, int var1, int[] var2);

    private static native short QTSNewPresentationFromDataRef(int var0, int var1, int var2, int[] var3);

    private static native short QTSPresExport(int var0, int var1, byte[] var2);

    private static native short QTSPresSetFlags(int var0, int var1, int var2);

    private static native short QTSPresGetFlags(int var0, int[] var1);

    private static native short QTSPresGetTimeScale(int var0, int[] var1);

    private static native short QTSPresSetInfo(int var0, int var1, int var2, byte[] var3);

    private static native short QTSPresGetInfo(int var0, int var1, int var2, byte[] var3);

    private static native short QTSPresGetInfo(int var0, int var1, int var2, int[] var3);

    private static native short QTSPresHasCharacteristic(int var0, int var1, int var2, byte[] var3);

    private static native short QTSPresSetNotificationProc(int var0, int var1, int[] var2);

    private static native short QTSPresGetNotificationProc(int var0, int var1, int[] var2);

    private static native short QTSPresPreview(int var0, int var1, long[] var2, int var3, int var4);

    private static native short QTSPresPreroll(int var0, int var1, int var2, int var3, int var4);

    private static native short QTSPresPreroll64(int var0, int var1, long[] var2, int var3, int var4);

    private static native short QTSPresStart(int var0, int var1, int var2);

    private static native void QTSPresIdle(int var0, int var1);

    private static native short QTSPresInvalidateRegion(int var0, int var1);

    private static native short QTSPresSkipTo(int var0, int var1);

    private static native short QTSPresSkipTo64(int var0, long[] var1);

    private static native short QTSPresStop(int var0, int var1, int var2);

    private static native int QTSPresGetNumStreams(int var0);

    private static native int QTSPresGetIndStream(int var0, int var1);

    private static native short QTSPresSetPreferredRate(int var0, int var1, int var2);

    private static native short QTSPresGetPreferredRate(int var0, int[] var1);

    private static native short QTSPresSetEnable(int var0, int var1, byte var2);

    private static native short QTSPresGetEnable(int var0, int var1, byte[] var2);

    private static native short QTSPresSetPresenting(int var0, int var1, byte var2);

    private static native short QTSPresGetPresenting(int var0, int var1, byte[] var2);

    private static native short QTSPresSetActiveSegment(int var0, int var1, long[] var2, long[] var3);

    private static native short QTSPresGetActiveSegment(int var0, int var1, long[] var2, long[] var3);

    private static native short QTSPresSetPlayHints(int var0, int var1, int var2, int var3);

    private static native short QTSPresGetPlayHints(int var0, int var1, int[] var2);

    private static native short QTSPresSetGWorld(int var0, int var1, int var2, int var3);

    private static native short QTSPresGetGWorld(int var0, int var1, int[] var2, int[] var3);

    private static native short QTSPresSetClip(int var0, int var1, int var2);

    private static native short QTSPresGetClip(int var0, int var1, int[] var2);

    private static native short QTSPresSetMatrix(int var0, int var1, byte[] var2);

    private static native short QTSPresGetMatrix(int var0, int var1, byte[] var2);

    private static native short QTSPresSetDimensions(int var0, int var1, int var2, int var3);

    private static native short QTSPresGetDimensions(int var0, int var1, int[] var2, int[] var3);

    private static native short QTSPresSetGraphicsMode(int var0, int var1, short var2, byte[] var3);

    private static native short QTSPresGetGraphicsMode(int var0, int var1, short[] var2, byte[] var3);

    private static native short QTSPresSetVolumes(int var0, int var1, short var2, short var3);

    private static native short QTSPresGetVolumes(int var0, int var1, short[] var2, short[] var3);

    private static native short QTSPresAddSourcer(int var0, int var1, int var2, int var3);

    private static native short QTSPresRemoveSourcer(int var0, int var1, int var2, int var3);

    private static native short QTSPresGetNumSourcers(int var0, int var1);

    private static native short QTSPresGetIndSourcer(int var0, int var1, int var2, int[] var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        owner = new Object();
        if (QTSession.hasSecurityRestrictions()) {
            throw new SecurityException("Only able to broadcast with security settings when class is signed");
        }
        if (QTSession.isCurrentOS(2)) {
            throw new RuntimeException("The broadcaster API is not supported on windows");
        }
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$streaming$Presentation == null ? (class$quicktime$streaming$Presentation = Presentation.class$("quicktime.streaming.Presentation")) : class$quicktime$streaming$Presentation);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

