/*
 * Decompiled with CFR 0.152.
 */
package quicktime.streaming;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.std.movies.Track;
import quicktime.streaming.SourcerLoopParams;
import quicktime.util.QTPointer;

public final class SourcerTrackParams
extends QTPointer {
    public static final int kNativeSize = 32;
    private Track itsTrack = null;
    private SourcerLoopParams itsParams = null;

    SourcerTrackParams() throws QTException {
        super(32, true);
    }

    SourcerTrackParams(byte[] byArray) throws QTException {
        super(byArray);
    }

    public SourcerTrackParams(int n, Track track) throws QTException {
        this(1, n, track, 0L, 0L, null);
    }

    public SourcerTrackParams(int n, Track track, long l, long l2, SourcerLoopParams sourcerLoopParams) throws QTException {
        this(1, n, track, l, l2, sourcerLoopParams);
    }

    public SourcerTrackParams(int n, int n2, Track track, long l, long l2, SourcerLoopParams sourcerLoopParams) throws QTException {
        super(32, true);
        this.setVersion(n);
        this.setFlags(n2);
        this.setTrack(track);
        this.setTrackStartOffset(l);
        this.setDuration(l2);
        this.setLoopParams(sourcerLoopParams);
    }

    public void setVersion(int n) {
        this.setIntAt(0, n);
    }

    public int getVersion() {
        return this.getIntAt(0);
    }

    public void setFlags(int n) {
        this.setIntAt(4, n);
    }

    public int getFlags() {
        return this.getIntAt(4);
    }

    public void setTrack(Track track) throws QTRuntimeException {
        if (track == null) {
            throw new QTRuntimeException("Track must not be null");
        }
        this.setIntAt(8, QTObject.ID(track));
        this.itsTrack = track;
    }

    public Track getTrack() {
        return this.itsTrack;
    }

    public void setTrackStartOffset(long l) {
        this.setLongAt(12, l);
    }

    public long getTrackStartOffset() {
        return this.getLongAt(12);
    }

    public void setDuration(long l) {
        this.setLongAt(20, l);
    }

    public long getDuration() {
        return this.getLongAt(20);
    }

    public void setLoopParams(SourcerLoopParams sourcerLoopParams) {
        if (sourcerLoopParams != null) {
            this.setIntAt(28, QTObject.ID(sourcerLoopParams));
            this.itsParams = sourcerLoopParams;
        } else {
            this.setIntAt(28, 0);
            this.itsParams = null;
        }
    }

    public SourcerLoopParams getLoopParams() {
        return this.itsParams;
    }

    public String toString() {
        return this.getClass().getName() + "[version=" + this.getVersion() + ",flags=" + this.getFlags() + ",track=" + this.getTrack() + ",trackStartOffset" + this.getTrackStartOffset() + ",duration" + this.getDuration() + ",loopParams" + this.getLoopParams() + "]";
    }
}

