/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.EncodedImage;
import quicktime.util.RawEncodedImage;

public class IntEncodedImage
implements PrimitivesLib,
EncodedImage,
Cloneable {
    static Object linkage;
    private int[] ints;
    private int rowBytes;
    static /* synthetic */ Class class$quicktime$util$IntEncodedImage;

    public static IntEncodedImage fromIntArray(int[] nArray) {
        return new IntEncodedImage(nArray);
    }

    public static IntEncodedImage fromIntArray(int[] nArray, int n) {
        return new IntEncodedImage(nArray, n);
    }

    public IntEncodedImage(RawEncodedImage rawEncodedImage) {
        int n = rawEncodedImage.getSize();
        if (n % 4 != 0) {
            ++n;
        }
        this.ints = new int[n];
        rawEncodedImage.copyToArray(0, this.ints, 0, rawEncodedImage.getSize());
        this.rowBytes = rawEncodedImage.getRowBytes();
    }

    public IntEncodedImage(int n) {
        this(n, -1);
    }

    public IntEncodedImage(int n, int n2) {
        this.ints = new int[n];
    }

    private IntEncodedImage(int[] nArray) {
        this(nArray, -1);
    }

    private IntEncodedImage(int[] nArray, int n) {
        this.ints = nArray;
        this.rowBytes = n;
    }

    public int[] getInts() {
        return this.ints;
    }

    public int getSize() {
        return this.ints.length * 4;
    }

    public byte getByte(int n) {
        if (n > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return IntEncodedImage.getByteFromArray(this.ints, n);
    }

    public short getShort(int n) {
        if (n > this.getSize() - 1 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return IntEncodedImage.getShortFromArray(this.ints, n);
    }

    public int getInt(int n) {
        if (n > this.getSize() - 3 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return IntEncodedImage.getIntFromArray(this.ints, n);
    }

    public int getRowBytes() {
        return this.rowBytes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof IntEncodedImage) {
            int[] nArray = ((IntEncodedImage)object).ints;
            if (nArray.length != this.ints.length) {
                return false;
            }
            for (int i = 0; i < this.ints.length; ++i) {
                if (this.ints[i] == nArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() {
        int[] nArray = new int[this.ints.length];
        System.arraycopy(this.ints, 0, nArray, 0, this.ints.length);
        return new IntEncodedImage(nArray, this.rowBytes);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static native byte getByteFromArray(int[] var0, int var1);

    private static native short getShortFromArray(int[] var0, int var1);

    private static native int getIntFromArray(int[] var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$IntEncodedImage == null ? (class$quicktime$util$IntEncodedImage = IntEncodedImage.class$("quicktime.util.IntEncodedImage")) : class$quicktime$util$IntEncodedImage);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

