/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.SoundDescription;
import quicktime.std.qtcomponents.ImageCompressionDialog;
import quicktime.std.qtcomponents.TimeCodeDescription;
import quicktime.std.qtcomponents.TimeCodeInfo;
import quicktime.std.qtcomponents.TimeCodeTime;
import quicktime.std.qtcomponents.TimeCoder;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointerRef;
import quicktime.util.RawEncodedImage;
import quicktime.util.UtilException;

public class QTHandle
extends QTHandleRef
implements QuickTimeLib {
    private static Object linkage;
    static /* synthetic */ Class class$quicktime$util$QTHandle;

    public static QTHandle fromGraphicsExporterText(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[]{0};
        int n = QTHandle.GraphicsExportGetSettingsAsText(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromGraphicsExporterInput(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[1];
        int n = QTHandle.GraphicsExportGetInputHandle(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromGraphicsExporterOutput(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[1];
        int n = QTHandle.GraphicsExportGetOutputHandle(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromSoundDescription(SoundDescription soundDescription, int n) throws QTException {
        int[] nArray = new int[1];
        short s = QTHandle.GetSoundDescriptionExtension(QTObject.ID(soundDescription), nArray, n);
        StdQTException.checkError(s);
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromImageDescription(ImageDescription imageDescription, int n, int n2) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QTHandle.GetImageDescriptionExtension(QTObject.ID(imageDescription), nArray, n, n2));
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromGraphicsImporterData(GraphicsImporter graphicsImporter) throws QTException {
        int[] nArray = new int[1];
        int n = QTHandle.GraphicsImportGetDataHandle(QTObject.ID(graphicsImporter), nArray);
        StdQTException.checkError(n);
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromGraphicsImporterAlias(GraphicsImporter graphicsImporter) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = QTHandle.GraphicsImportGetAliasedDataReference(QTObject.ID(graphicsImporter), nArray, nArray2);
        StdQTException.checkError(n);
        return new QTHandle(nArray[0], null, false);
    }

    public static TimeCodeInfo fromTimeCoderTime(TimeCoder timeCoder, int n) throws QTException {
        int[] nArray = new int[1];
        TimeCodeTime timeCodeTime = new TimeCodeTime();
        int[] nArray2 = new int[1];
        TimeCodeInfo timeCodeInfo = new TimeCodeInfo();
        int n2 = QTHandle.TCGetTimeCodeAtTime(QTObject.ID(timeCoder), n, nArray, timeCodeInfo.definition.getBytes(), timeCodeTime.getBytes(), nArray2);
        StdQTException.checkError(n2);
        timeCodeInfo.userData = nArray2[0] != 0 ? new QTHandle(nArray2[0], null, false) : null;
        timeCodeInfo.counter = timeCodeTime.toCounter();
        timeCodeInfo.time = timeCodeTime;
        timeCodeInfo.frameNumber = nArray[0];
        return timeCodeInfo;
    }

    public static TimeCodeInfo fromTimeCoderCurrent(TimeCoder timeCoder) throws QTException {
        int[] nArray = new int[1];
        TimeCodeTime timeCodeTime = new TimeCodeTime();
        boolean bl = false;
        int[] nArray2 = new int[1];
        TimeCodeInfo timeCodeInfo = new TimeCodeInfo();
        int n = QTHandle.TCGetCurrentTimeCode(QTObject.ID(timeCoder), nArray, timeCodeInfo.definition.getBytes(), timeCodeTime.getBytes(), nArray2);
        StdQTException.checkError(n);
        timeCodeInfo.userData = nArray2[0] != 0 ? new QTHandle(nArray2[0], null, false) : null;
        timeCodeInfo.counter = timeCodeTime.toCounter();
        timeCodeInfo.time = timeCodeTime;
        timeCodeInfo.frameNumber = nArray[0];
        return timeCodeInfo;
    }

    public static QTHandle fromTimeCoderSource(TimeCoder timeCoder, TimeCodeDescription timeCodeDescription) throws QTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QTHandle.TCGetSourceRef(QTObject.ID(timeCoder), QTObject.ID(timeCodeDescription), nArray));
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromTrack(Track track) throws QTException {
        int[] nArray = new int[1];
        short s = QTHandle.GetTrackSoundLocalizationSettings(QTObject.ID(track), nArray);
        StdQTException.checkError(s);
        return new QTHandle(nArray[0], null, false);
    }

    public static QTHandle fromEncodedImage(EncodedImage encodedImage) throws QTException {
        if (encodedImage instanceof ByteEncodedImage) {
            return new QTHandle(((ByteEncodedImage)encodedImage).getBytes());
        }
        if (encodedImage instanceof IntEncodedImage) {
            QTHandle qTHandle = new QTHandle(encodedImage.getSize(), false);
            int[] nArray = ((IntEncodedImage)encodedImage).getInts();
            qTHandle.copyFromArray(0, nArray, 0, nArray.length);
            return qTHandle;
        }
        if (encodedImage instanceof RawEncodedImage) {
            return new QTHandle((RawEncodedImage)encodedImage, 0, encodedImage.getSize());
        }
        return null;
    }

    public static void reserveMemory(int n) throws UtilException {
        QTHandle.ReserveMem(n);
        UtilException.checkError(QTHandle.MemError());
    }

    public QTHandle() throws QTException {
        this(4, true);
    }

    public QTHandle(int n, boolean bl) throws QTException {
        super(n, bl);
    }

    public QTHandle(byte[] byArray) throws QTException {
        super(byArray.length, false);
        this.setBytesAt(0, byArray.length, byArray, 0);
    }

    public QTHandle(QTPointerRef qTPointerRef, int n, int n2) throws QTException {
        this(QTHandle.copyPtr(qTPointerRef, n, n2), null, false);
    }

    public QTHandle(QTHandleRef qTHandleRef, QTHandleRef qTHandleRef2) throws QTException {
        this(qTHandleRef.makeAndCopyHandle(), null, false);
        this.concatenate(qTHandleRef2);
    }

    protected QTHandle(int n, Object object, boolean bl) {
        super(n, object, bl);
    }

    private static int copyPtr(QTPointerRef qTPointerRef, int n, int n2) throws UtilException {
        n2 = n2 + n > qTPointerRef.getSize() ? qTPointerRef.getSize() - n : n2;
        int[] nArray = new int[]{0};
        nArray[0] = QTHandle.NewHandleClear(4);
        UtilException.checkError(QTHandle.PtrToHand(QTObject.ID(qTPointerRef) + n, nArray, n2));
        return nArray[0];
    }

    public void setSize(int n) throws UtilException {
        QTHandle.SetHandleSize(this._ID(), n);
        UtilException.checkError(QTHandle.MemError());
    }

    public void concatenate(QTHandleRef qTHandleRef) throws UtilException {
        qTHandleRef.doLock();
        short s = QTHandle.HandAndHand(QTObject.ID(qTHandleRef), this._ID());
        if (!qTHandleRef.isLocked()) {
            qTHandleRef.unlock();
        }
        UtilException.checkError(s);
    }

    public static QTHandle fromImageCompressionDialog(ImageCompressionDialog imageCompressionDialog) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(QTHandle.SCGetInfo(QTObject.ID(imageCompressionDialog), 1667523939, nArray));
        return new QTHandle(nArray[0], null, false);
    }

    public Object clone() {
        return new QTHandle(this.makeAndCopyHandle(), null, false);
    }

    private static native short GetSoundDescriptionExtension(int var0, int[] var1, int var2);

    private static native short GetImageDescriptionExtension(int var0, int[] var1, int var2, int var3);

    private static native int GraphicsImportGetDataHandle(int var0, int[] var1);

    private static native int GraphicsImportGetAliasedDataReference(int var0, int[] var1, int[] var2);

    private static native int TCGetTimeCodeAtTime(int var0, int var1, int[] var2, byte[] var3, byte[] var4, int[] var5);

    private static native int TCGetCurrentTimeCode(int var0, int[] var1, byte[] var2, byte[] var3, int[] var4);

    private static native int TCGetSourceRef(int var0, int var1, int[] var2);

    private static native short GetTrackSoundLocalizationSettings(int var0, int[] var1);

    private static native void ReserveMem(int var0);

    private static native short MemError();

    private static native int NewHandleClear(int var0);

    private static native short PtrToHand(int var0, int[] var1, int var2);

    private static native void SetHandleSize(int var0, int var1);

    private static native short HandAndHand(int var0, int var1);

    private static native int GraphicsExportGetInputHandle(int var0, int[] var1);

    private static native int GraphicsExportGetOutputHandle(int var0, int[] var1);

    private static native int GraphicsExportGetSettingsAsText(int var0, int[] var1);

    private static native int SCGetInfo(int var0, int var1, int[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$QTHandle == null ? (class$quicktime$util$QTHandle = QTHandle.class$("quicktime.util.QTHandle")) : class$quicktime$util$QTHandle);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

