/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTNullPointerException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.sound.SoundComponentData;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointerRef;
import quicktime.util.RawEncodedImage;
import quicktime.util.UtilException;

public class QTPointer
extends QTPointerRef
implements QuickTimeLib,
Cloneable {
    private static Object linkage;
    static /* synthetic */ Class class$quicktime$util$QTPointer;

    public static QTPointerRef fromGraphicsExporter(GraphicsExporter graphicsExporter) throws StdQTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[1];
        int n = QTPointer.GraphicsExportGetInputPtr(QTObject.ID(graphicsExporter), nArray2, nArray);
        StdQTException.checkError(n);
        return new QTPointerRef(nArray2[0], nArray[0], graphicsExporter);
    }

    public static QTPointer fromSCData(SoundComponentData soundComponentData) {
        if (QTPointer.getIntFromArray(soundComponentData.getBytes(), 20) == 0) {
            throw new QTNullPointerException("SCD buffer is not set");
        }
        return new QTPointer(QTPointer.getIntFromArray(soundComponentData.getBytes(), 20), soundComponentData.getSampleSize() / 8 * soundComponentData.getSampleCount(), soundComponentData);
    }

    public static QTPointer fromEncodedImage(EncodedImage encodedImage) throws QTException {
        if (encodedImage instanceof ByteEncodedImage) {
            return new QTPointer(((ByteEncodedImage)encodedImage).getBytes());
        }
        if (encodedImage instanceof IntEncodedImage) {
            QTPointer qTPointer = new QTPointer(encodedImage.getSize(), false);
            int[] nArray = ((IntEncodedImage)encodedImage).getInts();
            qTPointer.copyFromArray(0, nArray, 0, nArray.length);
            return qTPointer;
        }
        if (encodedImage instanceof RawEncodedImage) {
            return (RawEncodedImage)encodedImage;
        }
        return null;
    }

    public QTPointer(int n, boolean bl) throws QTException {
        super(n, bl);
    }

    public QTPointer(byte[] byArray) throws QTException {
        super(byArray.length, false);
        this.setBytesAt(0, byArray.length, byArray, 0);
    }

    public QTPointer(QTHandleRef qTHandleRef, int n, int n2) throws QTException {
        super(n2 + n > qTHandleRef.getSize() ? qTHandleRef.getSize() - n : n2, false);
        int n3 = qTHandleRef.lockAndDeref(n);
        QTPointer.BlockMove(n3 + 0, this._ID() + 0, n2);
        if (!qTHandleRef.isLocked()) {
            qTHandleRef.unlock();
        }
    }

    public QTPointer(QTPointerRef qTPointerRef, QTPointerRef qTPointerRef2) throws QTException {
        super(qTPointerRef.getSize() + qTPointerRef2.getSize(), false);
        QTPointer.BlockMove(QTObject.ID(qTPointerRef) + 0, this._ID() + 0, qTPointerRef.getSize());
        QTPointer.BlockMove(QTObject.ID(qTPointerRef2) + 0, this._ID() + qTPointerRef.getSize(), qTPointerRef2.getSize());
    }

    QTPointer(int n, int n2, Object object) {
        super(n, n2, object);
    }

    public Object clone() {
        return new QTPointer(this.makeAndCopyPtr(0, this.getSize()), this.getSize(), null);
    }

    public void setSize(int n) throws UtilException {
        QTPointer.SetPtrSize(this._ID(), n);
        UtilException.checkError(QTPointer.MemError());
    }

    public void concatenate(QTPointerRef qTPointerRef) throws UtilException {
        int n = this.getSize();
        this.setSize(this.getSize() + qTPointerRef.getSize());
        QTPointer.BlockMove(QTObject.ID(qTPointerRef) + 0, this._ID() + n, qTPointerRef.getSize());
    }

    private static native int GraphicsExportGetInputPtr(int var0, int[] var1, int[] var2);

    private static native void BlockMove(int var0, int var1, int var2);

    private static native void SetPtrSize(int var0, int var1);

    private static native short MemError();

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(int[] var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$QTPointer == null ? (class$quicktime$util$QTPointer = QTPointer.class$("quicktime.util.QTPointer")) : class$quicktime$util$QTPointer);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

