/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.PixMap;
import quicktime.std.StdQTException;
import quicktime.std.anim.Sprite;
import quicktime.util.EncodedImage;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;

public final class RawEncodedImage
extends QTPointer
implements QuickTimeLib,
EncodedImage {
    private static Object linkage;
    private int rowBytes;
    static /* synthetic */ Class class$quicktime$util$RawEncodedImage;

    public static RawEncodedImage fromQTPointer(QTPointerRef qTPointerRef) {
        return new RawEncodedImage(QTObject.ID(qTPointerRef), qTPointerRef.getSize(), qTPointerRef, -1);
    }

    public static RawEncodedImage fromQTHandle(QTHandleRef qTHandleRef) {
        qTHandleRef.lock();
        return RawEncodedImage.fromQTPointer(qTHandleRef.toQTPointer());
    }

    public static RawEncodedImage fromPixMap(PixMap pixMap) {
        int n = RawEncodedImage.getShortFromHandle(QTObject.ID(pixMap), 10) - RawEncodedImage.getShortFromHandle(QTObject.ID(pixMap), 6);
        int n2 = RawEncodedImage.getShortFromHandle(QTObject.ID(pixMap), 4) & 0x3FFF;
        int n3 = n * n2;
        int n4 = pixMap.isOffscreen() ? RawEncodedImage.GetPixBaseAddr(QTObject.ID(pixMap)) : RawEncodedImage.getIntFromHandle(QTObject.ID(pixMap), 0);
        return new RawEncodedImage(n4, n3, pixMap, n2);
    }

    public static RawEncodedImage fromSprite(Sprite sprite) throws StdQTException {
        int[] nArray = new int[]{0};
        short s = RawEncodedImage.GetSpriteProperty(QTObject.ID(sprite), 3, nArray);
        StdQTException.checkError(s);
        return new RawEncodedImage(nArray[0], sprite.getImageDataSize(), sprite, -1);
    }

    public RawEncodedImage(byte[] byArray) throws QTException {
        super(byArray);
        this.rowBytes = -1;
    }

    public RawEncodedImage(int[] nArray) throws QTException {
        this(nArray.length * 4, false);
        this.copyFromArray(0, nArray, 0, nArray.length);
    }

    public RawEncodedImage(int[] nArray, int n) throws QTException {
        this(nArray.length * 4, false, n);
        this.copyFromArray(0, nArray, 0, nArray.length);
    }

    public RawEncodedImage(int n, boolean bl) throws QTException {
        super(n, bl);
        this.rowBytes = -1;
    }

    public RawEncodedImage(int n, boolean bl, int n2) throws QTException {
        super(n, bl);
        this.rowBytes = n2;
    }

    private RawEncodedImage(int n, int n2, Object object, int n3) {
        super(n, n2, object);
        this.rowBytes = n3;
    }

    public Object clone() {
        return new RawEncodedImage(this.makeAndCopyPtr(0, this.getSize()), this.getSize(), null, this.rowBytes);
    }

    public byte getByte(int n) {
        if (n > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getByteAt(n);
    }

    public void setByte(int n, byte by) {
        if (n > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setByteAt(n, by);
    }

    public short getShort(int n) {
        if (n > this.getSize() - 1 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getShortAt(n);
    }

    public void setShort(int n, short s) {
        if (n > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setShortAt(n, s);
    }

    public int getInt(int n) {
        if (n > this.getSize() - 3 || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getIntAt(n);
    }

    public void setInt(int n, int n2) {
        if (n > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setIntAt(n, n2);
    }

    public void setInts(int n, int[] nArray) {
        if (n + nArray.length * 4 > this.getSize() || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        RawEncodedImage.copyArrayToPointer(nArray, 0, this._ID(), n, nArray.length * 4);
    }

    public int getRowBytes() {
        return this.rowBytes;
    }

    public void setRowBytes(int n) {
        this.rowBytes = n;
    }

    private static native int GetPixBaseAddr(int var0);

    private static native short GetSpriteProperty(int var0, int var1, int[] var2);

    private static native short getShortFromHandle(int var0, int var1);

    private static native int getIntFromHandle(int var0, int var1);

    private static native void copyArrayToPointer(int[] var0, int var1, int var2, int var3, int var4);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        class PrivelegedAction {
            PrivelegedAction() {
            }

            void establish() {
                linkage = AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ PrivelegedAction this$0;
                    {
                        this.this$0 = privelegedAction;
                    }

                    public Object run() {
                        return QTNative.linkNativeMethods(class$quicktime$util$RawEncodedImage == null ? (class$quicktime$util$RawEncodedImage = RawEncodedImage.class$("quicktime.util.RawEncodedImage")) : class$quicktime$util$RawEncodedImage);
                    }
                });
            }
        }
        new PrivelegedAction().establish();
    }
}

