/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTByteObject;

public final class QTVRTrackRefEntry
extends QTByteObject
implements Cloneable {
    private static final int kNativeSize = 10;
    static final long serialVersionUID = 7513389675945192418L;
    private static EndianDescriptor ed;

    public QTVRTrackRefEntry() {
        super(10);
    }

    public QTVRTrackRefEntry(byte[] byArray) throws QTException {
        super(byArray);
        if (byArray.length != 10) {
            throw new QTException(-50);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[10];
        QTVRTrackRefEntry qTVRTrackRefEntry = new QTVRTrackRefEntry();
        objectInputStream.read(qTVRTrackRefEntry.getBytes());
        System.arraycopy(qTVRTrackRefEntry.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRTrackRefEntry qTVRTrackRefEntry = (QTVRTrackRefEntry)this.clone();
        objectOutputStream.write(qTVRTrackRefEntry.getBytes());
    }

    protected Object clone() {
        try {
            return new QTVRTrackRefEntry(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 4, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 2, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        EndianFlipSpec endianFlipSpec3 = new EndianFlipSpec(6, 4, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec3);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = QTVRTrackRefEntry.makeED();
        }
        return ed;
    }

    public int getTrackRefType() {
        return this.getIntAt(0);
    }

    public void setTrackRefType(int n) {
        this.setIntAt(0, n);
    }

    public short getTrackResolution() {
        return this.getShortAt(4);
    }

    public void setTrackResolution(short s) {
        this.setShortAt(4, s);
    }

    public int getTrackRefIndex() {
        return this.getIntAt(6);
    }

    public void setTrackRefIndex(int n) {
        this.setIntAt(6, n);
    }

    public String toString() {
        return this.getClass().getName() + "[trackRefType=" + this.getTrackRefType() + ",trackResolution=" + this.getTrackResolution() + ",trackRefIndex=" + this.getTrackRefIndex() + "]";
    }
}

