/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.ico;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class ICOEncoder
extends JimiEncoderBase {
    protected static final int BMPINFOHEADER_SIZE = 40;
    private boolean isEncodingFirstImage = true;
    protected LEDataOutputStream destination;
    protected short TYPE_FLAG = 1;
    protected int stateFlag = 4;
    protected int currentOffset = 0;

    protected int computeBitCount(int n) {
        if (n <= 4) {
            return 2;
        }
        if (n <= 16) {
            return 4;
        }
        return 8;
    }

    protected int computeImageSize(int n, int n2, int n3, int n4) {
        return n3 * n4;
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage adaptiveRasterImage = this.getJimiImage();
        try {
            AdaptiveRasterImage[] adaptiveRasterImageArray = new AdaptiveRasterImage[]{adaptiveRasterImage};
            this.writeICOCURDirectory(this.destination, adaptiveRasterImageArray);
            this.writeDIBImage(this.destination, adaptiveRasterImage);
        }
        catch (IOException iOException) {
            this.stateFlag = 1;
            throw new JimiException(iOException.toString());
        }
        catch (JimiException jimiException) {
            this.stateFlag = 1;
            throw jimiException;
        }
        this.stateFlag = 2;
        return false;
    }

    public void freeEncoder() throws JimiException {
    }

    public int getState() {
        return this.stateFlag;
    }

    public void initSpecificEncoder(OutputStream outputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.destination = new LEDataOutputStream(outputStream);
    }

    protected void writeBitmapInfoHeader(LEDataOutputStream lEDataOutputStream, int n, int n2, AdaptiveRasterImage adaptiveRasterImage, IndexColorModel indexColorModel) throws JimiException, IOException {
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight() * 2;
        int n5 = this.computeImageSize(n2, n, n3, n4);
        lEDataOutputStream.writeInt(40);
        lEDataOutputStream.writeInt(n3);
        lEDataOutputStream.writeInt(n4);
        lEDataOutputStream.writeShort(1);
        lEDataOutputStream.writeShort((short)n);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(n5);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt(0);
    }

    protected void writeDIBImage(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        IndexColorModel indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        int n = indexColorModel.getMapSize();
        int n2 = this.computeBitCount(n);
        this.writeBitmapInfoHeader(lEDataOutputStream, n2, n, adaptiveRasterImage, indexColorModel);
        this.writeRGBQuads(lEDataOutputStream, indexColorModel);
        this.writePixels(lEDataOutputStream, n2, adaptiveRasterImage);
    }

    protected void writeICOCURDIREntry(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        IndexColorModel indexColorModel;
        try {
            indexColorModel = (IndexColorModel)adaptiveRasterImage.getColorModel();
        }
        catch (ClassCastException classCastException) {
            throw new JimiException("image/x-ico formats can only be created from palette images");
        }
        int n = indexColorModel.getMapSize();
        if (n > 256) {
            throw new JimiException("image/x-ico formats can only support palette with up to 256 colors");
        }
        int n2 = this.computeBitCount(n);
        int n3 = adaptiveRasterImage.getWidth();
        int n4 = adaptiveRasterImage.getHeight();
        if (n3 > 256 || n4 > 256) {
            throw new JimiException("image/x-ico formats can only encode images up to 256 x 256 pixels");
        }
        int n5 = this.computeImageSize(n, n2, n3, n4);
        lEDataOutputStream.writeByte((byte)n3);
        lEDataOutputStream.writeByte((byte)n4);
        lEDataOutputStream.writeByte((byte)n);
        lEDataOutputStream.writeByte(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort((short)n2);
        int n6 = 40 + n5 * n2 / 8 + (int)Math.pow(2.0, n2);
        lEDataOutputStream.writeInt(n6);
        lEDataOutputStream.writeInt(this.currentOffset);
        this.currentOffset += n5;
    }

    protected void writeICOCURDirectory(LEDataOutputStream lEDataOutputStream, AdaptiveRasterImage[] adaptiveRasterImageArray) throws JimiException, IOException {
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(1);
        lEDataOutputStream.writeShort((short)adaptiveRasterImageArray.length);
        this.currentOffset = 6;
        this.currentOffset += adaptiveRasterImageArray.length * 16;
        int n = 0;
        while (n < adaptiveRasterImageArray.length) {
            this.writeICOCURDIREntry(lEDataOutputStream, adaptiveRasterImageArray[n]);
            ++n;
        }
    }

    protected void writePixels(LEDataOutputStream lEDataOutputStream, int n, AdaptiveRasterImage adaptiveRasterImage) throws JimiException, IOException {
        block10: {
            int[] nArray;
            int n2;
            int n3;
            block11: {
                int n4;
                block9: {
                    int n5;
                    adaptiveRasterImage.setRGBDefault(false);
                    n3 = adaptiveRasterImage.getHeight();
                    n2 = adaptiveRasterImage.getWidth();
                    nArray = new int[n2];
                    if (n != 2) break block9;
                    int n6 = n3 - 1;
                    while (n6 > -1) {
                        adaptiveRasterImage.getChannel(n6, nArray, 0);
                        int n7 = 0;
                        while (n7 < n2) {
                            n5 = (byte)(nArray[n7] << 6);
                            n5 = (byte)(n5 | (byte)(nArray[++n7] << 4));
                            n5 = (byte)(n5 | (byte)(nArray[++n7] << 2));
                            n5 = (byte)(n5 | (byte)nArray[++n7]);
                            ++n7;
                        }
                        --n6;
                    }
                    byte[] byArray = new byte[n2 / 4];
                    n5 = 0;
                    while (n5 < n3) {
                        lEDataOutputStream.write(byArray);
                        ++n5;
                    }
                    break block10;
                }
                if (n != 4) break block11;
                int n8 = n3 - 1;
                while (n8 > -1) {
                    adaptiveRasterImage.getChannel(n8, nArray, 0);
                    int n9 = 0;
                    while (n9 < n2) {
                        n4 = (byte)(nArray[n9] << 4);
                        n4 = (byte)(n4 | (byte)nArray[++n9]);
                        lEDataOutputStream.writeByte(n4);
                        ++n9;
                    }
                    --n8;
                }
                byte[] byArray = new byte[n2 / 2];
                n4 = 0;
                while (n4 < n3) {
                    lEDataOutputStream.write(byArray);
                    ++n4;
                }
                break block10;
            }
            if (n != 8) break block10;
            int n10 = n3 - 1;
            while (n10 > -1) {
                adaptiveRasterImage.getChannel(n10, nArray, 0);
                int n11 = 0;
                while (n11 < n2) {
                    lEDataOutputStream.writeByte((byte)nArray[n11]);
                    ++n11;
                }
                --n10;
            }
            byte[] byArray = new byte[n2];
            int n12 = 0;
            while (n12 < n3) {
                lEDataOutputStream.write(byArray);
                ++n12;
            }
        }
    }

    protected void writeRGBQuads(LEDataOutputStream lEDataOutputStream, IndexColorModel indexColorModel) throws JimiException, IOException {
        int n = indexColorModel.getMapSize();
        int n2 = this.computeBitCount(n);
        int n3 = (int)Math.pow(2.0, n2) - n;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getBlues(byArray2);
        indexColorModel.getGreens(byArray3);
        int n4 = 0;
        while (n4 < n) {
            lEDataOutputStream.writeByte(byArray2[n4]);
            lEDataOutputStream.writeByte(byArray3[n4]);
            lEDataOutputStream.writeByte(byArray[n4]);
            lEDataOutputStream.writeByte(0);
            ++n4;
        }
        byte[] byArray4 = new byte[4];
        int n5 = 0;
        while (n5 < n3) {
            lEDataOutputStream.write(byArray4);
            ++n5;
        }
    }
}

