/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;

class ImportConsumer
implements ImageConsumer {
    protected ImageProducer source;
    protected JimiImageFactory imageFactory;
    protected IntRasterImage intImage;
    protected ByteRasterImage byteImage;
    protected JimiRasterImage importedImage;
    protected int width = -1;
    protected int height = -1;
    protected ColorModel colorModel;
    protected boolean forceRGB;
    protected boolean finished;
    protected boolean aborted;

    public ImportConsumer(JimiImageFactory jimiImageFactory, ImageProducer imageProducer, boolean bl) {
        this.imageFactory = jimiImageFactory;
        this.source = imageProducer;
        this.forceRGB = bl;
    }

    protected synchronized void abort() {
        this.aborted = true;
        this.setFinished();
    }

    protected void checkProxy(byte[] byArray) throws JimiException {
        if (this.importedImage == null) {
            if (this.forceRGB) {
                this.createIntImage();
            } else {
                this.createByteImage();
            }
        }
    }

    protected void checkProxy(int[] nArray) throws JimiException {
        if (this.importedImage == null) {
            if (this.forceRGB) {
                this.createIntImage();
            } else {
                this.createIntImage();
            }
        }
    }

    protected void createByteImage() throws JimiException {
        if (this.colorModel instanceof IndexColorModel && ((IndexColorModel)this.colorModel).getMapSize() <= 2) {
            this.byteImage = this.imageFactory.createBitRasterImage(this.width, this.height, this.colorModel);
            this.importedImage = this.byteImage;
        } else {
            this.byteImage = this.imageFactory.createByteRasterImage(this.width, this.height, this.colorModel);
            this.importedImage = this.byteImage;
        }
    }

    protected void createIntImage() throws JimiException {
        this.intImage = this.imageFactory.createIntRasterImage(this.width, this.height, this.colorModel);
        this.importedImage = this.intImage;
    }

    public JimiRasterImage getImage() {
        return this.importedImage;
    }

    public void imageComplete(int n) {
        this.source.removeConsumer(this);
        if (!this.finished) {
            if (!this.finished && n != 1 && n != 4) {
                this.setFinished();
            } else {
                this.abort();
            }
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = this.forceRGB ? new DirectColorModel(24, 0xFF0000, 65280, 255) : colorModel;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected synchronized void setFinished() {
        this.finished = true;
        if (this.importedImage != null) {
            ((MutableJimiRasterImage)this.importedImage).setFinished();
        }
        this.notifyAll();
    }

    public void setHints(int n) {
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (this.finished) {
            return;
        }
        try {
            this.checkProxy(byArray);
        }
        catch (JimiException jimiException) {
            this.abort();
            return;
        }
        if (this.forceRGB) {
            this.setPixelsRGB(n, n2, n3, n4, colorModel, byArray, n5, n6);
        } else if (colorModel == this.colorModel) {
            try {
                this.byteImage.setRectangle(n, n2, n3, n4, byArray, n5, n6);
            }
            catch (ImageAccessException imageAccessException) {
                this.abort();
            }
        } else {
            this.abort();
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.finished) {
            return;
        }
        try {
            this.checkProxy(nArray);
        }
        catch (JimiException jimiException) {
            this.abort();
            return;
        }
        if (this.forceRGB) {
            this.setPixelsRGB(n, n2, n3, n4, colorModel, nArray, n5, n6);
        } else if (colorModel == this.colorModel) {
            try {
                this.intImage.setRectangle(n, n2, n3, n4, nArray, n5, n6);
            }
            catch (ImageAccessException imageAccessException) {
                this.abort();
            }
        } else {
            this.abort();
        }
    }

    protected void setPixelsRGB(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[byArray.length];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                nArray[n8] = colorModel.getRGB(byArray[n5 + n7 * n6 + n8]);
                ++n8;
            }
            try {
                this.intImage.setRectangle(n, n2 + n7, n3, 1, nArray, 0, n3);
            }
            catch (ImageAccessException imageAccessException) {
                this.abort();
            }
            ++n7;
        }
    }

    protected void setPixelsRGB(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int[] nArray2 = new int[nArray.length];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < n3) {
                nArray2[n8] = colorModel.getRGB(nArray[n5 + n7 * n6 + n8]);
                ++n8;
            }
            try {
                this.intImage.setRectangle(n, n2 + n7, n3, 1, nArray2, 0, n3);
            }
            catch (ImageAccessException imageAccessException) {
                this.abort();
            }
            ++n7;
        }
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void startImporting() {
        this.source.startProduction(this);
    }

    public synchronized void waitFinished() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

