/*
 * Decompiled with CFR 0.152.
 */
package com.bric.plaf;

import com.bric.util.JVM;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.UIManager;

public class PlafPaintUtils {
    static final Color[] whites = new Color[]{new Color(255, 255, 255, 50), new Color(255, 255, 255, 100), new Color(255, 255, 255, 150)};
    static final Color[] blacks = new Color[]{new Color(0, 0, 0, 50), new Color(0, 0, 0, 100), new Color(0, 0, 0, 150)};
    private static Hashtable verticalGradients;
    private static Hashtable checkers;

    public static Color getFocusRingColor() {
        Color color = UIManager.getColor("Focus.color");
        if (color instanceof Color) {
            return color;
        }
        color = UIManager.getColor("focusRing");
        if (color instanceof Color) {
            return color;
        }
        return new Color(64, 113, 167);
    }

    public static void paintFocus(Graphics2D graphics2D, Shape shape, int n) {
        Color color = PlafPaintUtils.getFocusRingColor();
        Color[] colorArray = new Color[]{new Color(color.getRed(), color.getGreen(), color.getBlue(), 235), new Color(color.getRed(), color.getGreen(), color.getBlue(), 130), new Color(color.getRed(), color.getGreen(), color.getBlue(), 80)};
        if (JVM.usingQuartz) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
        graphics2D.setStroke(new BasicStroke(2 * n + 1, 1, 1));
        graphics2D.setColor(colorArray[2]);
        graphics2D.draw(shape);
        if (2 * n + 1 > 0) {
            graphics2D.setStroke(new BasicStroke(2 * n - 2 + 1, 1, 1));
            graphics2D.setColor(colorArray[1]);
            graphics2D.draw(shape);
        }
        if (2 * n - 4 + 1 > 0) {
            graphics2D.setStroke(new BasicStroke(2 * n - 4 + 1, 1, 1));
            graphics2D.setColor(colorArray[0]);
            graphics2D.draw(shape);
        }
    }

    public static void drawBevel(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setStroke(new BasicStroke(1.0f));
        PlafPaintUtils.drawColors(blacks, graphics2D, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 5);
        PlafPaintUtils.drawColors(blacks, graphics2D, rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, 3);
        PlafPaintUtils.drawColors(whites, graphics2D, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y, 1);
        PlafPaintUtils.drawColors(whites, graphics2D, rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height, 7);
        graphics2D.setColor(new Color(120, 120, 120));
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private static void drawColors(Color[] colorArray, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < colorArray.length; ++i) {
            graphics.setColor(colorArray[colorArray.length - i - 1]);
            if (n5 == 5) {
                graphics.drawLine(n, n2 - i, n3, n4 - i);
                continue;
            }
            if (n5 == 1) {
                graphics.drawLine(n, n2 + i, n3, n4 + i);
                continue;
            }
            if (n5 == 3) {
                graphics.drawLine(n - i, n2, n3 - i, n4);
                continue;
            }
            if (n5 != 7) continue;
            graphics.drawLine(n + i, n2, n3 + i, n4);
        }
    }

    static synchronized Paint getVerticalGradient(String string, int n, int n2, float[] fArray, Color[] colorArray) {
        String string2;
        Paint paint;
        if (verticalGradients == null) {
            verticalGradients = new Hashtable();
        }
        if ((paint = (Paint)verticalGradients.get(string2 = string + " " + n + " " + n2)) == null) {
            n = Math.max(n, 1);
            BufferedImage bufferedImage = new BufferedImage(1, n, 2);
            int[] nArray = new int[n];
            for (int i = 0; i < nArray.length; ++i) {
                float f = i;
                f /= (float)(nArray.length - 1);
                boolean bl = false;
                for (int j = 1; j < fArray.length; ++j) {
                    if (!(f >= fArray[j - 1]) || !(f < fArray[j])) continue;
                    float f2 = (f - fArray[j - 1]) / (fArray[j] - fArray[j - 1]);
                    nArray[i] = PlafPaintUtils.tween(colorArray[j - 1], colorArray[j], f2).getRGB();
                    bl = true;
                    break;
                }
                if (bl) continue;
                nArray[i] = colorArray[colorArray.length - 1].getRGB();
            }
            bufferedImage.getRaster().setDataElements(0, 0, 1, n, nArray);
            paint = new TexturePaint(bufferedImage, new Rectangle(0, n2, 1, n));
            verticalGradients.put(string2, paint);
        }
        return paint;
    }

    private static Color tween(Color color, Color color2, float f) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = color2.getRed();
        int n6 = color2.getGreen();
        int n7 = color2.getBlue();
        int n8 = color2.getAlpha();
        return new Color((int)((float)n * (1.0f - f) + (float)n5 * f), (int)((float)n2 * (1.0f - f) + (float)n6 * f), (int)((float)n3 * (1.0f - f) + (float)n7 * f), (int)((float)n4 * (1.0f - f) + (float)n8 * f));
    }

    public static TexturePaint getCheckerBoard(int n) {
        Integer n2;
        TexturePaint texturePaint;
        if (checkers == null) {
            checkers = new Hashtable();
        }
        if ((texturePaint = (TexturePaint)checkers.get(n2 = new Integer(n))) == null) {
            BufferedImage bufferedImage = new BufferedImage(2 * n, 2 * n, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, 2 * n, 2 * n);
            graphics2D.setColor(Color.lightGray);
            graphics2D.fillRect(0, 0, n, n);
            graphics2D.fillRect(n, n, n, n);
            graphics2D.dispose();
            texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
            checkers.put(n2, texturePaint);
        }
        return texturePaint;
    }
}

