/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.plaf.ColorPickerSliderUI;
import com.bric.swing.ColorPickerDialog;
import com.bric.swing.ColorPickerPanel;
import com.bric.swing.ColorSwatch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColorPicker
extends JPanel {
    private static final long serialVersionUID = 3L;
    protected static ResourceBundle strings = ResourceBundle.getBundle("com.bric.swing.resources.ColorPicker");
    public static final String SELECTED_COLOR_PROPERTY = "selected color";
    public static final String MODE_CONTROLS_VISIBLE_PROPERTY = "mode controls visible";
    public static final String OPACITY_PROPERTY = "opacity";
    public static final String MODE_PROPERTY = "mode";
    public static final int HUE = 0;
    public static final int BRI = 1;
    public static final int SAT = 2;
    public static final int RED = 3;
    public static final int GREEN = 4;
    public static final int BLUE = 5;
    private JSlider slider = new JSlider(1, 0, 100, 0);
    private int currentRed = 0;
    private int currentGreen = 0;
    private int currentBlue = 0;
    ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (ColorPicker.this.hue.contains(object) || ColorPicker.this.sat.contains(object) || ColorPicker.this.bri.contains(object)) {
                if (ColorPicker.this.adjustingSpinners > 0) {
                    return;
                }
                ColorPicker.this.setHSB(ColorPicker.this.hue.getFloatValue() / 360.0f, ColorPicker.this.sat.getFloatValue() / 100.0f, ColorPicker.this.bri.getFloatValue() / 100.0f);
            } else if (ColorPicker.this.red.contains(object) || ColorPicker.this.green.contains(object) || ColorPicker.this.blue.contains(object)) {
                if (ColorPicker.this.adjustingSpinners > 0) {
                    return;
                }
                ColorPicker.this.setRGB(ColorPicker.this.red.getIntValue(), ColorPicker.this.green.getIntValue(), ColorPicker.this.blue.getIntValue());
            } else if (object == ColorPicker.this.colorPanel) {
                if (ColorPicker.this.adjustingColorPanel > 0) {
                    return;
                }
                int n = ColorPicker.this.getMode();
                if (n == 0 || n == 1 || n == 2) {
                    float[] fArray = ColorPicker.this.colorPanel.getHSB();
                    ColorPicker.this.setHSB(fArray[0], fArray[1], fArray[2]);
                } else {
                    int[] nArray = ColorPicker.this.colorPanel.getRGB();
                    ColorPicker.this.setRGB(nArray[0], nArray[1], nArray[2]);
                }
            } else if (object == ColorPicker.this.slider) {
                if (ColorPicker.this.adjustingSlider > 0) {
                    return;
                }
                int n = ColorPicker.this.slider.getValue();
                Option option = ColorPicker.this.getSelectedOption();
                option.setValue(n);
            } else if (ColorPicker.this.alpha.contains(object)) {
                if (ColorPicker.this.adjustingOpacity > 0) {
                    return;
                }
                int n = ColorPicker.this.alpha.getIntValue();
                ColorPicker.this.setOpacity(n);
            } else if (object == ColorPicker.this.opacitySlider) {
                if (ColorPicker.this.adjustingOpacity > 0) {
                    return;
                }
                ColorPicker.this.setOpacity(ColorPicker.this.opacitySlider.getValue());
            }
        }
    };
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ((ColorPicker)ColorPicker.this).hue.radioButton) {
                ColorPicker.this.setMode(0);
            } else if (object == ((ColorPicker)ColorPicker.this).bri.radioButton) {
                ColorPicker.this.setMode(1);
            } else if (object == ((ColorPicker)ColorPicker.this).sat.radioButton) {
                ColorPicker.this.setMode(2);
            } else if (object == ((ColorPicker)ColorPicker.this).red.radioButton) {
                ColorPicker.this.setMode(3);
            } else if (object == ((ColorPicker)ColorPicker.this).green.radioButton) {
                ColorPicker.this.setMode(4);
            } else if (object == ((ColorPicker)ColorPicker.this).blue.radioButton) {
                ColorPicker.this.setMode(5);
            }
        }
    };
    HexDocumentListener hexDocListener = new HexDocumentListener();
    private Option alpha = new Option(strings.getObject("alphaLabel").toString(), 255);
    private Option hue = new Option(strings.getObject("hueLabel").toString(), 360);
    private Option sat = new Option(strings.getObject("saturationLabel").toString(), 100);
    private Option bri = new Option(strings.getObject("brightnessLabel").toString(), 100);
    private Option red = new Option(strings.getObject("redLabel").toString(), 255);
    private Option green = new Option(strings.getObject("greenLabel").toString(), 255);
    private Option blue = new Option(strings.getObject("blueLabel").toString(), 255);
    private ColorSwatch preview = new ColorSwatch(50);
    private JLabel hexLabel = new JLabel(strings.getObject("hexLabel").toString());
    private JTextField hexField = new JTextField("000000");
    private int adjustingSpinners = 0;
    private int adjustingSlider = 0;
    private int adjustingColorPanel = 0;
    private int adjustingHexField = 0;
    private int adjustingOpacity = 0;
    private JPanel expertControls = new JPanel(new GridBagLayout());
    private ColorPickerPanel colorPanel = new ColorPickerPanel();
    private JSlider opacitySlider = new JSlider(0, 255, 255);
    private JLabel opacityLabel = new JLabel(strings.getObject("opacityLabel").toString());
    private int lastOpacity = 255;

    public static Color showDialog(Window window, Color color) {
        return ColorPicker.showDialog(window, null, color, false);
    }

    public static Color showDialog(Window window, Color color, boolean bl) {
        return ColorPicker.showDialog(window, null, color, bl);
    }

    public static Color showDialog(Window window, String string, Color color, boolean bl) {
        ColorPickerDialog colorPickerDialog;
        if (window instanceof Frame || window == null) {
            colorPickerDialog = new ColorPickerDialog((Frame)window, color, bl);
        } else if (window instanceof Dialog) {
            colorPickerDialog = new ColorPickerDialog((Dialog)window, color, bl);
        } else {
            throw new IllegalArgumentException("the owner (" + window.getClass().getName() + ") must be a java.awt.Frame or a java.awt.Dialog");
        }
        colorPickerDialog.setTitle(string == null ? strings.getObject("ColorPickerDialogTitle").toString() : string);
        colorPickerDialog.pack();
        colorPickerDialog.setVisible(true);
        return colorPickerDialog.getColor();
    }

    private Option getSelectedOption() {
        int n = this.getMode();
        if (n == 0) {
            return this.hue;
        }
        if (n == 2) {
            return this.sat;
        }
        if (n == 1) {
            return this.bri;
        }
        if (n == 3) {
            return this.red;
        }
        if (n == 4) {
            return this.green;
        }
        return this.blue;
    }

    public ColorPicker() {
        this(true, false);
    }

    public ColorPicker(boolean bl, boolean bl2) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(3, 3, 3, 3);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        ButtonGroup buttonGroup = new ButtonGroup();
        Option[] optionArray = new Option[]{this.hue, this.sat, this.bri, this.red, this.green, this.blue};
        for (int i = 0; i < optionArray.length; ++i) {
            gridBagConstraints.insets = i == 3 || i == 6 ? new Insets(insets.top + 10, insets.left, insets.bottom, insets.right) : insets;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)optionArray[i].label, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            if (optionArray[i].spinner != null) {
                jPanel.add((Component)optionArray[i].spinner, gridBagConstraints);
            } else {
                jPanel.add((Component)optionArray[i].slider, gridBagConstraints);
            }
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            jPanel.add((Component)optionArray[i].radioButton, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            buttonGroup.add(optionArray[i].radioButton);
        }
        gridBagConstraints.insets = new Insets(insets.top + 10, insets.left, insets.bottom, insets.right);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.hexLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.hexField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.alpha.label, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.alpha.spinner, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.colorPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx += 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.slider, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.expertControls, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.opacityLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.opacitySlider, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(insets.top, insets.left + 8, insets.bottom + 10, insets.right + 8);
        this.expertControls.add((Component)this.preview, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(insets.top, insets.left, 0, insets.right);
        this.expertControls.add((Component)jPanel, gridBagConstraints);
        this.preview.setOpaque(true);
        this.colorPanel.setPreferredSize(new Dimension(this.expertControls.getPreferredSize().height, this.expertControls.getPreferredSize().height));
        this.slider.addChangeListener(this.changeListener);
        this.colorPanel.addChangeListener(this.changeListener);
        this.slider.setUI(new ColorPickerSliderUI(this.slider, this));
        this.hexField.getDocument().addDocumentListener(this.hexDocListener);
        this.setMode(1);
        this.setExpertControlsVisible(bl);
        this.setOpacityVisible(bl2);
        this.opacitySlider.addChangeListener(this.changeListener);
        this.setOpacity(255);
        ColorPicker.setOpaque(this, false);
        this.preview.setForeground(this.getColor());
    }

    private static void setOpaque(JComponent jComponent, boolean bl) {
        if (jComponent instanceof JTextField) {
            return;
        }
        jComponent.setOpaque(false);
        if (jComponent instanceof JSpinner) {
            return;
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i);
            ColorPicker.setOpaque(jComponent2, bl);
        }
    }

    public void setHexControlsVisible(boolean bl) {
        this.hexLabel.setVisible(bl);
        this.hexField.setVisible(bl);
    }

    public void setPreviewSwatchVisible(boolean bl) {
        this.preview.setVisible(bl);
    }

    public void setExpertControlsVisible(boolean bl) {
        this.expertControls.setVisible(bl);
    }

    public float[] getHSB() {
        return new float[]{this.hue.getFloatValue() / 360.0f, this.sat.getFloatValue() / 100.0f, this.bri.getFloatValue() / 100.0f};
    }

    public int[] getRGB() {
        return new int[]{this.currentRed, this.currentGreen, this.currentBlue};
    }

    public float getOpacity() {
        return (float)this.opacitySlider.getValue() / 255.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpacity(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("The opacity (" + n + ") must be between 0 and 255.");
        }
        ++this.adjustingOpacity;
        try {
            this.opacitySlider.setValue(n);
            this.alpha.spinner.setValue(n);
            if (this.lastOpacity != n) {
                this.firePropertyChange(OPACITY_PROPERTY, new Integer(this.lastOpacity), new Integer(n));
                Color color = this.preview.getForeground();
                this.preview.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
            }
            this.lastOpacity = n;
        }
        finally {
            --this.adjustingOpacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int n) {
        if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4 && n != 5) {
            throw new IllegalArgumentException("mode must be HUE, SAT, BRI, REd, GREEN, or BLUE");
        }
        this.putClientProperty(MODE_PROPERTY, new Integer(n));
        this.hue.radioButton.setSelected(n == 0);
        this.sat.radioButton.setSelected(n == 2);
        this.bri.radioButton.setSelected(n == 1);
        this.red.radioButton.setSelected(n == 3);
        this.green.radioButton.setSelected(n == 4);
        this.blue.radioButton.setSelected(n == 5);
        this.colorPanel.setMode(n);
        ++this.adjustingSlider;
        try {
            this.slider.setValue(0);
            Option option = this.getSelectedOption();
            this.slider.setInverted(n == 0);
            int n2 = option.getMaximum();
            this.slider.setMaximum(n2);
            this.slider.setValue(option.getIntValue());
            this.slider.repaint();
            if (n == 0 || n == 2 || n == 1) {
                this.setHSB(this.hue.getFloatValue() / 360.0f, this.sat.getFloatValue() / 100.0f, this.bri.getFloatValue() / 100.0f);
            } else {
                this.setRGB(this.red.getIntValue(), this.green.getIntValue(), this.blue.getIntValue());
            }
        }
        finally {
            --this.adjustingSlider;
        }
    }

    public void setModeControlsVisible(boolean bl) {
        this.hue.radioButton.setVisible(bl && this.hue.isVisible());
        this.sat.radioButton.setVisible(bl && this.sat.isVisible());
        this.bri.radioButton.setVisible(bl && this.bri.isVisible());
        this.red.radioButton.setVisible(bl && this.red.isVisible());
        this.green.radioButton.setVisible(bl && this.green.isVisible());
        this.blue.radioButton.setVisible(bl && this.blue.isVisible());
        this.putClientProperty(MODE_CONTROLS_VISIBLE_PROPERTY, bl);
    }

    public int getMode() {
        Integer n = (Integer)this.getClientProperty(MODE_PROPERTY);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setColor(Color color) {
        this.setRGB(color.getRed(), color.getGreen(), color.getBlue());
        this.setOpacity(color.getAlpha());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(int n, int n2, int n3) {
        Object object;
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("The red value (" + n + ") must be between [0,255].");
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("The green value (" + n2 + ") must be between [0,255].");
        }
        if (n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("The blue value (" + n3 + ") must be between [0,255].");
        }
        Color color = this.getColor();
        boolean bl = this.adjustingSpinners == 0;
        ++this.adjustingSpinners;
        ++this.adjustingColorPanel;
        int n4 = this.alpha.getIntValue();
        try {
            if (bl) {
                this.red.setValue(n);
                this.green.setValue(n2);
                this.blue.setValue(n3);
            }
            this.preview.setForeground(new Color(n, n2, n3, n4));
            object = new float[3];
            Color.RGBtoHSB(n, n2, n3, object);
            this.hue.setValue((int)(object[0] * 360.0f + 0.49f));
            this.sat.setValue((int)(object[1] * 100.0f + 0.49f));
            this.bri.setValue((int)(object[2] * 100.0f + 0.49f));
            this.colorPanel.setRGB(n, n2, n3);
            this.updateHexField();
            this.updateSlider();
        }
        finally {
            --this.adjustingSpinners;
            --this.adjustingColorPanel;
        }
        this.currentRed = n;
        this.currentGreen = n2;
        this.currentBlue = n3;
        object = this.getColor();
        if (!color.equals(object)) {
            this.firePropertyChange(SELECTED_COLOR_PROPERTY, color, object);
        }
    }

    public Color getColor() {
        int[] nArray = this.getRGB();
        return new Color(nArray[0], nArray[1], nArray[2], this.opacitySlider.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSlider() {
        ++this.adjustingSlider;
        try {
            int n = this.getMode();
            if (n == 0) {
                this.slider.setValue(this.hue.getIntValue());
            } else if (n == 2) {
                this.slider.setValue(this.sat.getIntValue());
            } else if (n == 1) {
                this.slider.setValue(this.bri.getIntValue());
            } else if (n == 3) {
                this.slider.setValue(this.red.getIntValue());
            } else if (n == 4) {
                this.slider.setValue(this.green.getIntValue());
            } else if (n == 5) {
                this.slider.setValue(this.blue.getIntValue());
            }
        }
        finally {
            --this.adjustingSlider;
        }
        this.slider.repaint();
    }

    public JPanel getExpertControls() {
        return this.expertControls;
    }

    public void setRGBControlsVisible(boolean bl) {
        this.red.setVisible(bl);
        this.green.setVisible(bl);
        this.blue.setVisible(bl);
    }

    public void setHSBControlsVisible(boolean bl) {
        this.hue.setVisible(bl);
        this.sat.setVisible(bl);
        this.bri.setVisible(bl);
    }

    public void setOpacityVisible(boolean bl) {
        this.opacityLabel.setVisible(bl);
        this.opacitySlider.setVisible(bl);
        this.alpha.label.setVisible(bl);
        this.alpha.spinner.setVisible(bl);
    }

    public ColorPickerPanel getColorPanel() {
        return this.colorPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHSB(float f, float f2, float f3) {
        Color color;
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new IllegalArgumentException("The hue value (" + f + ") is not a valid number.");
        }
        while (f < 0.0f) {
            f += 1.0f;
        }
        while (f > 1.0f) {
            f -= 1.0f;
        }
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("The saturation value (" + f2 + ") must be between [0,1]");
        }
        if (f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("The brightness value (" + f3 + ") must be between [0,1]");
        }
        Color color2 = this.getColor();
        boolean bl = this.adjustingSpinners == 0;
        ++this.adjustingSpinners;
        ++this.adjustingColorPanel;
        try {
            if (bl) {
                this.hue.setValue((int)(f * 360.0f + 0.49f));
                this.sat.setValue((int)(f2 * 100.0f + 0.49f));
                this.bri.setValue((int)(f3 * 100.0f + 0.49f));
            }
            color = new Color(Color.HSBtoRGB(f, f2, f3));
            int n = this.alpha.getIntValue();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            this.preview.setForeground(color);
            this.currentRed = color.getRed();
            this.currentGreen = color.getGreen();
            this.currentBlue = color.getBlue();
            this.red.setValue(this.currentRed);
            this.green.setValue(this.currentGreen);
            this.blue.setValue(this.currentBlue);
            this.colorPanel.setHSB(f, f2, f3);
            this.updateHexField();
            this.updateSlider();
            this.slider.repaint();
        }
        finally {
            --this.adjustingSpinners;
            --this.adjustingColorPanel;
        }
        color = this.getColor();
        if (!color2.equals(color)) {
            this.firePropertyChange(SELECTED_COLOR_PROPERTY, color2, color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHexField() {
        ++this.adjustingHexField;
        try {
            int n = this.red.getIntValue();
            int n2 = this.green.getIntValue();
            int n3 = this.blue.getIntValue();
            int n4 = (n << 16) + (n2 << 8) + n3;
            String string = Integer.toHexString(n4).toUpperCase();
            while (string.length() < 6) {
                string = "0" + string;
            }
            if (!this.hexField.getText().equalsIgnoreCase(string)) {
                this.hexField.setText(string);
            }
        }
        finally {
            --this.adjustingHexField;
        }
    }

    class Option {
        JRadioButton radioButton = new JRadioButton();
        JSpinner spinner;
        JSlider slider;
        JLabel label;

        public Option(String string, int n) {
            this.spinner = new JSpinner(new SpinnerNumberModel(0, 0, n, 5));
            this.spinner.addChangeListener(ColorPicker.this.changeListener);
            this.label = new JLabel(string);
            this.radioButton.addActionListener(ColorPicker.this.actionListener);
        }

        public void setValue(int n) {
            if (this.slider != null) {
                this.slider.setValue(n);
            }
            if (this.spinner != null) {
                this.spinner.setValue(new Integer(n));
            }
        }

        public int getMaximum() {
            if (this.slider != null) {
                return this.slider.getMaximum();
            }
            return ((Number)((Object)((SpinnerNumberModel)this.spinner.getModel()).getMaximum())).intValue();
        }

        public boolean contains(Object object) {
            return object == this.slider || object == this.spinner || object == this.radioButton || object == this.label;
        }

        public float getFloatValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            if (this.slider != null) {
                return this.slider.getValue();
            }
            return ((Number)this.spinner.getValue()).intValue();
        }

        public boolean isVisible() {
            return this.label.isVisible();
        }

        public void setVisible(boolean bl) {
            boolean bl2 = true;
            Boolean bl3 = (Boolean)ColorPicker.this.getClientProperty(ColorPicker.MODE_CONTROLS_VISIBLE_PROPERTY);
            if (bl3 != null) {
                bl2 = bl3;
            }
            this.radioButton.setVisible(bl && bl2);
            if (this.slider != null) {
                this.slider.setVisible(bl);
            }
            if (this.spinner != null) {
                this.spinner.setVisible(bl);
            }
            this.label.setVisible(bl);
        }
    }

    class HexDocumentListener
    implements DocumentListener {
        long lastTimeStamp;

        HexDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.lastTimeStamp = System.currentTimeMillis();
            if (ColorPicker.this.adjustingHexField > 0) {
                return;
            }
            String string = ColorPicker.this.hexField.getText();
            if ((string = this.stripToHex(string)).length() == 6) {
                try {
                    int n = Integer.parseInt(string, 16);
                    ColorPicker.this.setRGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            HexUpdateThread hexUpdateThread = new HexUpdateThread(this.lastTimeStamp, string);
            hexUpdateThread.start();
            while (System.currentTimeMillis() - this.lastTimeStamp == 0L) {
                Thread.yield();
            }
        }

        private String stripToHex(String string) {
            string = string.toUpperCase();
            String string2 = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != '0' && c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9' && c != 'A' && c != 'B' && c != 'C' && c != 'D' && c != 'E' && c != 'F') continue;
                string2 = string2 + c;
            }
            return string2;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    }

    class HexUpdateThread
    extends Thread {
        long myStamp;
        String text;

        public HexUpdateThread(long l, String string) {
            this.myStamp = l;
            this.text = string;
        }

        @Override
        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                long l = 1500L;
                while (System.currentTimeMillis() - this.myStamp < l) {
                    try {
                        long l2 = l - (System.currentTimeMillis() - this.myStamp);
                        if (l2 < 1L) {
                            l2 = 1L;
                        }
                        Thread.sleep(l2);
                    }
                    catch (Exception exception) {
                        Thread.yield();
                    }
                }
                SwingUtilities.invokeLater(this);
                return;
            }
            if (this.myStamp != ColorPicker.this.hexDocListener.lastTimeStamp) {
                return;
            }
            if (this.text.length() > 6) {
                this.text = this.text.substring(0, 6);
            }
            while (this.text.length() < 6) {
                this.text = this.text + "0";
            }
            if (ColorPicker.this.hexField.getText().equals(this.text)) {
                return;
            }
            int n = ColorPicker.this.hexField.getCaretPosition();
            ColorPicker.this.hexField.setText(this.text);
            ColorPicker.this.hexField.setCaretPosition(n);
        }
    }
}

