/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.plaf.PlafPaintUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class ColorPickerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SIZE = 325;
    private int mode = 1;
    private Point point = new Point(0, 0);
    private Vector changeListeners = new Vector();
    float hue = -1.0f;
    float sat = -1.0f;
    float bri = -1.0f;
    int red = -1;
    int green = -1;
    int blue = -1;
    MouseInputListener mouseListener = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ColorPickerPanel.this.requestFocus();
            Point point = mouseEvent.getPoint();
            if (ColorPickerPanel.this.mode == 1 || ColorPickerPanel.this.mode == 2 || ColorPickerPanel.this.mode == 0) {
                float[] fArray = ColorPickerPanel.this.getHSB(point);
                ColorPickerPanel.this.setHSB(fArray[0], fArray[1], fArray[2]);
            } else {
                int[] nArray = ColorPickerPanel.this.getRGB(point);
                ColorPickerPanel.this.setRGB(nArray[0], nArray[1], nArray[2]);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.mousePressed(mouseEvent);
        }
    };
    KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = 0;
            int n2 = 0;
            if (keyEvent.getKeyCode() == 37) {
                n = -1;
            } else if (keyEvent.getKeyCode() == 39) {
                n = 1;
            } else if (keyEvent.getKeyCode() == 38) {
                n2 = -1;
            } else if (keyEvent.getKeyCode() == 40) {
                n2 = 1;
            }
            int n3 = 1;
            if (keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                n3 = 10;
            } else if (keyEvent.isShiftDown() || keyEvent.isAltDown()) {
                n3 = 5;
            }
            if (n != 0 || n2 != 0) {
                int n4 = Math.min(325, Math.min(ColorPickerPanel.this.getWidth() - ColorPickerPanel.this.imagePadding.left - ColorPickerPanel.this.imagePadding.right, ColorPickerPanel.this.getHeight() - ColorPickerPanel.this.imagePadding.top - ColorPickerPanel.this.imagePadding.bottom));
                int n5 = ColorPickerPanel.this.getWidth() / 2 - n4 / 2;
                int n6 = ColorPickerPanel.this.getHeight() / 2 - n4 / 2;
                ColorPickerPanel.this.mouseListener.mousePressed(new MouseEvent(ColorPickerPanel.this, 501, System.currentTimeMillis(), 0, ((ColorPickerPanel)ColorPickerPanel.this).point.x + n3 * n + n5, ((ColorPickerPanel)ColorPickerPanel.this).point.y + n3 * n2 + n6, 1, false));
            }
        }
    };
    FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            ColorPickerPanel.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ColorPickerPanel.this.repaint();
        }
    };
    ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            ColorPickerPanel.this.regeneratePoint();
            ColorPickerPanel.this.regenerateImage();
        }
    };
    BufferedImage image = new BufferedImage(325, 325, 2);
    Insets imagePadding = new Insets(6, 6, 6, 6);
    private int[] row = new int[325];

    public ColorPickerPanel() {
        this.setMaximumSize(new Dimension(325 + this.imagePadding.left + this.imagePadding.right, 325 + this.imagePadding.top + this.imagePadding.bottom));
        this.setPreferredSize(new Dimension(243, 243));
        this.setRGB(0, 0, 0);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setFocusable(true);
        this.addKeyListener(this.keyListener);
        this.addFocusListener(this.focusListener);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addComponentListener(this.componentListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners.contains(changeListener)) {
            return;
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.changeListeners.get(i);
            try {
                changeListener.stateChanged(new ChangeEvent(this));
                continue;
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle;
        RectangularShape rectangularShape;
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        graphics2D.translate(this.getWidth() / 2 - n / 2, this.getHeight() / 2 - n / 2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mode == 2 || this.mode == 1) {
            rectangularShape = new Ellipse2D.Float(0.0f, 0.0f, n, n);
        } else {
            rectangle = new Rectangle(0, 0, n, n);
            rectangularShape = rectangle;
        }
        if (this.hasFocus()) {
            PlafPaintUtils.paintFocus(graphics2D, rectangularShape, 3);
        }
        if (!(rectangularShape instanceof Rectangle)) {
            graphics2D.translate(2, 2);
            graphics2D.setColor(new Color(0, 0, 0, 20));
            graphics2D.fill(new Ellipse2D.Float(-2.0f, -2.0f, n + 4, n + 4));
            graphics2D.setColor(new Color(0, 0, 0, 40));
            graphics2D.fill(new Ellipse2D.Float(-1.0f, -1.0f, n + 2, n + 2));
            graphics2D.setColor(new Color(0, 0, 0, 80));
            graphics2D.fill(new Ellipse2D.Float(0.0f, 0.0f, n, n));
            graphics2D.translate(-2, -2);
        }
        graphics2D.drawImage(this.image, 0, 0, n, n, 0, 0, n, n, null);
        graphics2D.setStroke(new BasicStroke(1.0f));
        if (rectangularShape instanceof Rectangle) {
            rectangle = (Rectangle)rectangularShape;
            PlafPaintUtils.drawBevel(graphics2D, rectangle);
        } else {
            graphics2D.setColor(new Color(0, 0, 0, 120));
            graphics2D.draw(rectangularShape);
        }
        graphics2D.setColor(Color.white);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(new Ellipse2D.Float(this.point.x - 3, this.point.y - 3, 6.0f, 6.0f));
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Ellipse2D.Float(this.point.x - 4, this.point.y - 4, 8.0f, 8.0f));
        graphics.translate(-this.imagePadding.left, -this.imagePadding.top);
    }

    public void setMode(int n) {
        if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4 && n != 5) {
            throw new IllegalArgumentException("The mode must be HUE, SAT, BRI, RED, GREEN, or BLUE.");
        }
        if (this.mode == n) {
            return;
        }
        this.mode = n;
        this.regenerateImage();
        this.regeneratePoint();
    }

    public void setRGB(int n, int n2, int n3) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("The red value (" + n + ") must be between [0,255].");
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("The green value (" + n2 + ") must be between [0,255].");
        }
        if (n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("The blue value (" + n3 + ") must be between [0,255].");
        }
        if (this.red != n || this.green != n2 || this.blue != n3) {
            if (this.mode == 3 || this.mode == 4 || this.mode == 5) {
                int n4 = this.red;
                int n5 = this.green;
                int n6 = this.blue;
                this.red = n;
                this.green = n2;
                this.blue = n3;
                if (this.mode == 3) {
                    if (n4 != n) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 4) {
                    if (n5 != n2) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 5 && n6 != n3) {
                    this.regenerateImage();
                }
            } else {
                float[] fArray = new float[3];
                Color.RGBtoHSB(n, n2, n3, fArray);
                this.setHSB(fArray[0], fArray[1], fArray[2]);
                return;
            }
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    public float[] getHSB() {
        return new float[]{this.hue, this.sat, this.bri};
    }

    public int[] getRGB() {
        return new int[]{this.red, this.green, this.blue};
    }

    public float[] getHSB(Point point) {
        if (this.mode == 3 || this.mode == 4 || this.mode == 5) {
            int[] nArray = this.getRGB(point);
            float[] fArray = Color.RGBtoHSB(nArray[0], nArray[1], nArray[2], null);
            return fArray;
        }
        int n = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        point.translate(-(this.getWidth() / 2 - n / 2), -(this.getHeight() / 2 - n / 2));
        if (this.mode == 1 || this.mode == 2) {
            double d = (double)n / 2.0;
            double d2 = point.getX() - (double)n / 2.0;
            double d3 = point.getY() - (double)n / 2.0;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3) / d;
            double d5 = Math.atan2(d3, d2) / (Math.PI * 2);
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            if (this.mode == 1) {
                return new float[]{(float)(d5 + 0.25), (float)d4, this.bri};
            }
            return new float[]{(float)(d5 + 0.25), this.sat, (float)d4};
        }
        float f = (float)point.x / (float)n;
        float f2 = (float)point.y / (float)n;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return new float[]{this.hue, f, f2};
    }

    public int[] getRGB(Point point) {
        if (this.mode == 1 || this.mode == 2 || this.mode == 0) {
            float[] fArray = this.getHSB(point);
            int n = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
            int n2 = (n & 0xFF0000) >> 16;
            int n3 = (n & 0xFF00) >> 8;
            int n4 = n & 0xFF;
            return new int[]{n2, n3, n4};
        }
        int n = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        point.translate(-(this.getWidth() / 2 - n / 2), -(this.getHeight() / 2 - n / 2));
        int n5 = point.x * 255 / n;
        int n6 = point.y * 255 / n;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 > 255) {
            n6 = 255;
        }
        if (this.mode == 3) {
            return new int[]{this.red, n5, n6};
        }
        if (this.mode == 4) {
            return new int[]{n5, this.green, n6};
        }
        return new int[]{n5, n6, this.blue};
    }

    public void setHSB(float f, float f2, float f3) {
        f = (float)((double)f - Math.floor(f));
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("The saturation value (" + f2 + ") must be between [0,1]");
        }
        if (f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("The brightness value (" + f3 + ") must be between [0,1]");
        }
        if (this.hue != f || this.sat != f2 || this.bri != f3) {
            if (this.mode == 0 || this.mode == 1 || this.mode == 2) {
                float f4 = this.hue;
                float f5 = this.bri;
                float f6 = this.sat;
                this.hue = f;
                this.sat = f2;
                this.bri = f3;
                if (this.mode == 0) {
                    if (f4 != this.hue) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 2) {
                    if (f6 != this.sat) {
                        this.regenerateImage();
                    }
                } else if (this.mode == 1 && f5 != this.bri) {
                    this.regenerateImage();
                }
            } else {
                Color color = new Color(Color.HSBtoRGB(f, f2, f3));
                this.setRGB(color.getRed(), color.getGreen(), color.getBlue());
                return;
            }
            Color color = new Color(Color.HSBtoRGB(this.hue, this.sat, this.bri));
            this.red = color.getRed();
            this.green = color.getGreen();
            this.blue = color.getBlue();
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    private void regeneratePoint() {
        int n = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        if (this.mode == 0 || this.mode == 2 || this.mode == 1) {
            if (this.mode == 0) {
                this.point = new Point((int)((double)(this.sat * (float)n) + 0.5), (int)((double)(this.bri * (float)n) + 0.5));
            } else if (this.mode == 2) {
                double d = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                if (d < 0.0) {
                    d += Math.PI * 2;
                }
                double d2 = this.bri * (float)n / 2.0f;
                this.point = new Point((int)(d2 * Math.cos(d) + 0.5 + (double)n / 2.0), (int)(d2 * Math.sin(d) + 0.5 + (double)n / 2.0));
            } else if (this.mode == 1) {
                double d = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                if (d < 0.0) {
                    d += Math.PI * 2;
                }
                double d3 = this.sat * (float)n / 2.0f;
                this.point = new Point((int)(d3 * Math.cos(d) + 0.5 + (double)n / 2.0), (int)(d3 * Math.sin(d) + 0.5 + (double)n / 2.0));
            }
        } else if (this.mode == 3) {
            this.point = new Point((int)((float)(this.green * n) / 255.0f + 0.49f), (int)((float)(this.blue * n) / 255.0f + 0.49f));
        } else if (this.mode == 4) {
            this.point = new Point((int)((float)(this.red * n) / 255.0f + 0.49f), (int)((float)(this.blue * n) / 255.0f + 0.49f));
        } else if (this.mode == 5) {
            this.point = new Point((int)((float)(this.red * n) / 255.0f + 0.49f), (int)((float)(this.green * n) / 255.0f + 0.49f));
        }
    }

    private synchronized void regenerateImage() {
        int n = Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
        if (this.mode == 1 || this.mode == 2) {
            float f = this.bri;
            float f2 = this.sat;
            float f3 = (float)n / 2.0f;
            float f4 = 1.2f;
            for (int i = 0; i < n; ++i) {
                float f5 = (float)i - (float)n / 2.0f;
                for (int j = 0; j < n; ++j) {
                    double d;
                    float f6 = (float)j - (float)n / 2.0f;
                    double d2 = Math.atan2(f5, f6) - 4.71238898038469;
                    if (d2 < 0.0) {
                        d2 += Math.PI * 2;
                    }
                    if ((d = Math.sqrt(f6 * f6 + f5 * f5)) <= (double)f3) {
                        float f7;
                        if (this.mode == 1) {
                            f7 = (float)(d2 / (Math.PI * 2));
                            f2 = (float)(d / (double)f3);
                        } else {
                            f7 = (float)(d2 / (Math.PI * 2));
                            f = (float)(d / (double)f3);
                        }
                        this.row[j] = Color.HSBtoRGB(f7, f2, f);
                        if (!(d > (double)(f3 - f4))) continue;
                        int n2 = (int)(255.0 - 255.0 * (d - (double)f3 + (double)f4) / (double)f4);
                        if (n2 < 0) {
                            n2 = 0;
                        }
                        if (n2 > 255) {
                            n2 = 255;
                        }
                        this.row[j] = this.row[j] & 0xFFFFFF + (n2 << 24);
                        continue;
                    }
                    this.row[j] = 0;
                }
                this.image.getRaster().setDataElements(0, i, n, 1, this.row);
            }
        } else if (this.mode == 0) {
            float f = this.hue;
            for (int i = 0; i < n; ++i) {
                float f8 = (float)i / (float)n;
                for (int j = 0; j < n; ++j) {
                    float f9 = (float)j / (float)n;
                    this.row[j] = Color.HSBtoRGB(f, f9, f8);
                }
                this.image.getRaster().setDataElements(0, i, this.image.getWidth(), 1, this.row);
            }
        } else {
            int n3 = this.red;
            int n4 = this.green;
            int n5 = this.blue;
            for (int i = 0; i < n; ++i) {
                float f = (float)i / (float)n;
                for (int j = 0; j < n; ++j) {
                    float f10 = (float)j / (float)n;
                    if (this.mode == 3) {
                        n4 = (int)((double)(f10 * 255.0f) + 0.49);
                        n5 = (int)((double)(f * 255.0f) + 0.49);
                    } else if (this.mode == 4) {
                        n3 = (int)((double)(f10 * 255.0f) + 0.49);
                        n5 = (int)((double)(f * 255.0f) + 0.49);
                    } else {
                        n3 = (int)((double)(f10 * 255.0f) + 0.49);
                        n4 = (int)((double)(f * 255.0f) + 0.49);
                    }
                    this.row[j] = -16777216 + (n3 << 16) + (n4 << 8) + n5;
                }
                this.image.getRaster().setDataElements(0, i, n, 1, this.row);
            }
        }
        this.repaint();
    }
}

