/*
 * Decompiled with CFR 0.152.
 */
package com.bric.swing;

import com.bric.plaf.MultiThumbSliderUI;
import com.bric.swing.ColorPicker;
import com.bric.swing.MultiThumbSlider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import javax.swing.JColorChooser;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;

public class GradientSlider
extends MultiThumbSlider {
    private static final long serialVersionUID = 1L;
    JPopupMenu popup;

    public GradientSlider() {
        this(0);
    }

    public GradientSlider(int n) {
        this(n, new float[]{0.0f, 1.0f}, new Color[]{Color.white, Color.black});
    }

    public GradientSlider(int n, float[] fArray, Color[] colorArray) {
        super(n, fArray, colorArray);
    }

    @Override
    public Object getValue(float f) {
        for (int i = 0; i < this.thumbPositions.length - 1; ++i) {
            if (!(this.thumbPositions[i] <= f) || !(f <= this.thumbPositions[i + 1])) continue;
            float f2 = (f - this.thumbPositions[i]) / (this.thumbPositions[i + 1] - this.thumbPositions[i]);
            return GradientSlider.tween((Color)this.values[i], (Color)this.values[i + 1], f2);
        }
        if (f < this.thumbPositions[0]) {
            return (Color)this.values[0];
        }
        if (f > this.thumbPositions[this.thumbPositions.length - 1]) {
            return (Color)this.values[this.values.length - 1];
        }
        return null;
    }

    public Color[] getColors() {
        Color[] colorArray = new Color[this.values.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = (Color)this.values[i];
        }
        return colorArray;
    }

    private static Color tween(Color color, Color color2, float f) {
        if (f == 0.0f) {
            return color;
        }
        if (f == 1.0f) {
            return color2;
        }
        return new Color((int)((float)color.getRed() * (1.0f - f) + (float)color2.getRed() * f), (int)((float)color.getGreen() * (1.0f - f) + (float)color2.getGreen() * f), (int)((float)color.getBlue() * (1.0f - f) + (float)color2.getBlue() * f), (int)((float)color.getAlpha() * (1.0f - f) + (float)color2.getAlpha() * f));
    }

    @Override
    public boolean doDoubleClick(int n, int n2) {
        int n3 = this.getSelectedThumb();
        if (n3 != -1) {
            this.showColorPicker();
            SwingUtilities.invokeLater(new SelectThumbRunnable(n3));
            return true;
        }
        return false;
    }

    private JPopupMenu createPopup() {
        return new ColorPickerPopup();
    }

    @Override
    public boolean doPopup(int n, int n2) {
        if (this.popup == null) {
            this.popup = this.createPopup();
        }
        this.popup.show(this, n, n2);
        return true;
    }

    private Frame getFrame() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private boolean showColorPicker() {
        Object[] objectArray = this.getColors();
        int n = this.getSelectedThumb();
        Frame frame = this.getFrame();
        boolean bl = MultiThumbSliderUI.getProperty(this, "GradientSlider.colorPickerIncludesOpacity", "true").equals("true");
        objectArray[n] = ColorPicker.showDialog(frame, objectArray[n], bl);
        if (objectArray[n] != null) {
            this.setValues(this.getThumbPositions(), objectArray);
        }
        return true;
    }

    private void showJColorChooser() {
        Object[] objectArray = this.getColors();
        int n = this.getSelectedThumb();
        if (n >= 0 && n < objectArray.length) {
            objectArray[n] = JColorChooser.showDialog(this, "Choose a Color", objectArray[n]);
            if (objectArray[n] != null) {
                this.setValues(this.getThumbPositions(), objectArray);
            }
        }
    }

    @Override
    public void updateUI() {
        String string = UIManager.getString("GradientSliderUI");
        if (string == null) {
            string = "com.bric.plaf.GradientSliderUI";
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length != 1 || !classArray[0].equals(GradientSlider.class)) continue;
                ComponentUI componentUI = (ComponentUI)constructorArray[i].newInstance(this);
                this.setUI(componentUI);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("The class \"" + string + "\" could not be found.");
        }
        catch (Throwable throwable) {
            RuntimeException runtimeException = new RuntimeException("The class \"" + string + "\" could not be constructed.");
            runtimeException.initCause(throwable);
            throw runtimeException;
        }
    }

    static {
        if (UIManager.getString("GradientSliderUI") == null) {
            UIManager.put("GradientSliderUI", "com.bric.plaf.GradientSliderUI");
        }
    }

    class ColorPickerPopup
    extends AbstractPopup {
        private static final long serialVersionUID = 1L;
        ColorPicker mini;
        KeyListener commitListener;

        public ColorPickerPopup() {
            this.commitListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                        ColorPickerPopup.this.setVisible(false);
                    }
                }
            };
            boolean bl = MultiThumbSliderUI.getProperty(GradientSlider.this, "GradientSlider.includeOpacity", "true").equals("true");
            this.mini = new ColorPicker(false, bl);
            this.mini.setMode(0);
            this.mini.setPreferredSize(new Dimension(220, 200));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ColorPicker colorPicker = (ColorPicker)propertyChangeEvent.getSource();
                    Object[] objectArray = GradientSlider.this.getColors();
                    objectArray[ColorPickerPopup.this.lastSelectedThumb] = colorPicker.getColor();
                    GradientSlider.this.setValues(GradientSlider.this.getThumbPositions(), objectArray);
                }
            };
            this.mini.addPropertyChangeListener("selected color", propertyChangeListener);
            this.mini.addPropertyChangeListener("opacity", propertyChangeListener);
            for (int i = 0; i < this.mini.getComponentCount(); ++i) {
                Component component = this.mini.getComponent(i);
                component.addKeyListener(this.commitListener);
            }
            this.add(this.mini);
        }

        @Override
        public Component getFocusableComponent() {
            return this.mini.getColorPanel();
        }

        @Override
        public void setColor(Color color) {
            this.mini.setRGB(color.getRed(), color.getGreen(), color.getBlue());
            this.mini.setOpacity(color.getAlpha());
        }
    }

    abstract class AbstractPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        int lastSelectedThumb;
        PopupMenuListener popupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                GradientSlider.this.setValueIsAdjusting(false);
                SwingUtilities.invokeLater(new SelectThumbRunnable(AbstractPopup.this.lastSelectedThumb));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GradientSlider.this.setValueIsAdjusting(false);
                SwingUtilities.invokeLater(new SelectThumbRunnable(AbstractPopup.this.lastSelectedThumb));
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                GradientSlider.this.setValueIsAdjusting(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractPopup.this.getFocusableComponent().requestFocus();
                    }
                });
            }
        };

        public AbstractPopup() {
            this.addPopupMenuListener(this.popupMenuListener);
        }

        public abstract Component getFocusableComponent();

        @Override
        public void show(Component component, int n, int n2) {
            Color[] colorArray = GradientSlider.this.getColors();
            this.lastSelectedThumb = GradientSlider.this.getSelectedThumb();
            if (this.lastSelectedThumb != -1) {
                this.setColor(colorArray[this.lastSelectedThumb]);
                super.show(component, n, n2);
            }
        }

        public abstract void setColor(Color var1);
    }

    class SelectThumbRunnable
    implements Runnable {
        int index;

        public SelectThumbRunnable(int n) {
            this.index = n;
        }

        @Override
        public void run() {
            GradientSlider.this.setSelectedThumb(this.index);
        }
    }
}

