/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class ShapeStroke
implements Stroke {
    private Shape[] shapes;
    private float advance;
    private boolean repeat = true;
    private AffineTransform t = new AffineTransform();
    private static final float FLATNESS = 1.0f;

    public ShapeStroke(Shape shape, float f) {
        this(new Shape[]{shape}, f);
    }

    public ShapeStroke(Shape[] shapeArray, float f) {
        this.advance = f;
        this.shapes = new Shape[shapeArray.length];
        for (int i = 0; i < this.shapes.length; ++i) {
            Rectangle2D rectangle2D = shapeArray[i].getBounds2D();
            this.t.setToTranslation(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
            this.shapes[i] = this.t.createTransformedShape(shapeArray[i]);
        }
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath generalPath = new GeneralPath();
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        boolean bl = false;
        float f7 = 0.0f;
        int n2 = 0;
        int n3 = this.shapes.length;
        float f8 = 1.0f;
        while (n2 < n3 && !flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    generalPath.moveTo(f, f2);
                    bl = true;
                    f7 = 0.0f;
                    break;
                }
                case 4: {
                    fArray[0] = f;
                    fArray[1] = f2;
                }
                case 1: {
                    f5 = fArray[0];
                    f6 = fArray[1];
                    float f9 = f5 - f3;
                    float f10 = f6 - f4;
                    float f11 = (float)Math.sqrt(f9 * f9 + f10 * f10);
                    if (f11 >= f7) {
                        float f12 = 1.0f / f11;
                        float f13 = (float)Math.atan2(f10, f9);
                        while (n2 < n3 && f11 >= f7) {
                            float f14 = f3 + f7 * f9 * f12;
                            float f15 = f4 + f7 * f10 * f12;
                            this.t.setToTranslation(f14, f15);
                            this.t.rotate(f13);
                            generalPath.append(this.t.createTransformedShape(this.shapes[n2]), false);
                            f7 += this.advance;
                            ++n2;
                            if (!this.repeat) continue;
                            n2 %= n3;
                        }
                    }
                    f7 -= f11;
                    bl = false;
                    f3 = f5;
                    f4 = f6;
                }
            }
            flatteningPathIterator.next();
        }
        return generalPath;
    }
}

