/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.image.BufferedImage;

public class BlockFilter
extends AbstractBufferedImageOp {
    private int blockSize = 2;

    public BlockFilter() {
    }

    public BlockFilter(int n) {
        this.blockSize = n;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[this.blockSize * this.blockSize];
        for (int i = 0; i < n2; i += this.blockSize) {
            for (int j = 0; j < n; j += this.blockSize) {
                int n3;
                int n4;
                int n5;
                int n6 = Math.min(this.blockSize, n - j);
                int n7 = Math.min(this.blockSize, n2 - i);
                int n8 = n6 * n7;
                this.getRGB(bufferedImage, j, i, n6, n7, nArray);
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                for (n5 = 0; n5 < n7; ++n5) {
                    for (n4 = 0; n4 < n6; ++n4) {
                        n3 = nArray[n12];
                        n9 += n3 >> 16 & 0xFF;
                        n10 += n3 >> 8 & 0xFF;
                        n11 += n3 & 0xFF;
                        ++n12;
                    }
                }
                n3 = n9 / n8 << 16 | n10 / n8 << 8 | n11 / n8;
                n12 = 0;
                for (n5 = 0; n5 < n7; ++n5) {
                    for (n4 = 0; n4 < n6; ++n4) {
                        nArray[n12] = nArray[n12] & 0xFF000000 | n3;
                        ++n12;
                    }
                }
                this.setRGB(bufferedImage2, j, i, n6, n7, nArray);
            }
        }
        return bufferedImage2;
    }

    public String toString() {
        return "Pixellate/Mosaic...";
    }
}

