/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.jdesktop.swingx.plaf.ErrorPaneAddon;
import org.jdesktop.swingx.plaf.ErrorPaneUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXErrorPane
extends JComponent {
    public static final String REPORT_ACTION_KEY = "report-action";
    public static final String FATAL_ACTION_KEY = "fatal-action";
    public static final String uiClassID = "ErrorPaneUI";
    private ErrorInfo errorInfo = new ErrorInfo("Error", "Normally this place contains problem description.\n You see this text because one of the following reasons:\n * Either it is a test\n * Developer have not provided error details\n * This error message was invoked unexpectedly and there are no more details available", null, null, null, null, null);
    private Icon icon;
    private ErrorReporter reporter;

    public JXErrorPane() {
        this.updateUI();
    }

    @Override
    public ErrorPaneUI getUI() {
        return (ErrorPaneUI)this.ui;
    }

    public void setUI(ErrorPaneUI errorPaneUI) {
        super.setUI(errorPaneUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((ErrorPaneUI)LookAndFeelAddons.getUI(this, ErrorPaneUI.class));
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        if (errorInfo == null) {
            throw new NullPointerException("ErrorInfo can't be null. Provide valid ErrorInfo object.");
        }
        ErrorInfo errorInfo2 = this.errorInfo;
        this.errorInfo = errorInfo;
        this.firePropertyChange("errorInfo", errorInfo2, this.errorInfo);
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.icon;
        this.icon = icon;
        this.firePropertyChange("icon", icon2, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        ErrorReporter errorReporter2 = this.getErrorReporter();
        this.reporter = errorReporter;
        this.firePropertyChange("errorReporter", errorReporter2, this.getErrorReporter());
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public static void showDialog(Throwable throwable) {
        ErrorInfo errorInfo = new ErrorInfo(null, null, null, null, throwable, null, null);
        JXErrorPane.showDialog(null, errorInfo);
    }

    public static void showDialog(Component component, ErrorInfo errorInfo) {
        JXErrorPane jXErrorPane = new JXErrorPane();
        jXErrorPane.setErrorInfo(errorInfo);
        JXErrorPane.showDialog(component, jXErrorPane);
    }

    public static void showDialog(final Component component, final JXErrorPane jXErrorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JDialog jDialog = JXErrorPane.createDialog(component, jXErrorPane);
                jDialog.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    public static JDialog createDialog(Component component, JXErrorPane jXErrorPane) {
        JDialog jDialog = jXErrorPane.getUI().getErrorDialog(component);
        if (component != null) {
            jXErrorPane.applyComponentOrientation(component.getComponentOrientation());
        } else {
            jXErrorPane.applyComponentOrientation(jDialog.getComponentOrientation());
        }
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        return jDialog;
    }

    public static void showFrame(Throwable throwable) {
        ErrorInfo errorInfo = new ErrorInfo(null, null, null, null, throwable, null, null);
        JXErrorPane.showFrame(null, errorInfo);
    }

    public static void showFrame(Component component, ErrorInfo errorInfo) {
        JXErrorPane jXErrorPane = new JXErrorPane();
        jXErrorPane.setErrorInfo(errorInfo);
        JXErrorPane.showFrame(component, jXErrorPane);
    }

    public static void showFrame(final Component component, final JXErrorPane jXErrorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = JXErrorPane.createFrame(component, jXErrorPane);
                jFrame.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    public static JFrame createFrame(Component component, JXErrorPane jXErrorPane) {
        JFrame jFrame = jXErrorPane.getUI().getErrorFrame(component);
        if (component != null) {
            jXErrorPane.applyComponentOrientation(component.getComponentOrientation());
        } else {
            jXErrorPane.applyComponentOrientation(jFrame.getComponentOrientation());
        }
        jFrame.setDefaultCloseOperation(2);
        jFrame.pack();
        return jFrame;
    }

    public static void showInternalFrame(Throwable throwable) {
        ErrorInfo errorInfo = new ErrorInfo(null, null, null, null, throwable, null, null);
        JXErrorPane.showInternalFrame(null, errorInfo);
    }

    public static void showInternalFrame(Component component, ErrorInfo errorInfo) {
        JXErrorPane jXErrorPane = new JXErrorPane();
        jXErrorPane.setErrorInfo(errorInfo);
        JXErrorPane.showInternalFrame(component, jXErrorPane);
    }

    public static void showInternalFrame(final Component component, final JXErrorPane jXErrorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JInternalFrame jInternalFrame = JXErrorPane.createInternalFrame(component, jXErrorPane);
                jInternalFrame.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    public static JInternalFrame createInternalFrame(Component component, JXErrorPane jXErrorPane) {
        JInternalFrame jInternalFrame = jXErrorPane.getUI().getErrorInternalFrame(component);
        if (component != null) {
            jXErrorPane.applyComponentOrientation(component.getComponentOrientation());
        } else {
            jXErrorPane.applyComponentOrientation(jInternalFrame.getComponentOrientation());
        }
        jInternalFrame.setDefaultCloseOperation(2);
        jInternalFrame.pack();
        return jInternalFrame;
    }

    static {
        LookAndFeelAddons.contribute(new ErrorPaneAddon());
    }
}

