/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class TextPainter
extends AbstractAreaPainter<Object> {
    private String text = "";
    private Font font = null;

    public TextPainter() {
        this("");
    }

    public TextPainter(String string) {
        this(string, null, null);
    }

    public TextPainter(String string, Font font) {
        this(string, font, null);
    }

    public TextPainter(String string, Paint paint) {
        this(string, null, paint);
    }

    public TextPainter(String string, Font font, Paint paint) {
        this.text = string;
        this.font = font;
        this.setFillPaint(paint);
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        this.font = font;
        this.setDirty(true);
        this.firePropertyChange("font", font2, this.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String string) {
        String string2 = this.getText();
        this.text = string == null ? "" : string;
        this.setDirty(true);
        this.firePropertyChange("text", string2, this.getText());
    }

    public String getText() {
        return this.text;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        Paint paint;
        Font font = this.calculateFont(object);
        if (font != null) {
            graphics2D.setFont(font);
        }
        if ((paint = this.getFillPaint()) == null && object instanceof JComponent) {
            paint = ((JComponent)object).getForeground();
        }
        String string = this.calculateText(object);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getHeight();
        Rectangle rectangle = this.calculateLayout(n3, n4, n, n2);
        graphics2D.translate(rectangle.x, rectangle.y);
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, rectangle.width, rectangle.height);
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        graphics2D.drawString(string, 0, 0 + fontMetrics.getAscent());
        if (this.getAreaEffects() != null) {
            Shape shape = this.provideShape(graphics2D, object, n, n2);
            for (AreaEffect areaEffect : this.getAreaEffects()) {
                areaEffect.apply(graphics2D, shape, n, n2);
            }
        }
        graphics2D.translate(-rectangle.x, -rectangle.y);
    }

    protected String calculateText(Object object) {
        String string = this.getText();
        if (string != null && !string.trim().equals("")) {
            return string;
        }
        if (object instanceof JTextComponent) {
            string = ((JTextComponent)object).getText();
        }
        if (object instanceof JLabel) {
            string = ((JLabel)object).getText();
        }
        if (object instanceof AbstractButton) {
            string = ((AbstractButton)object).getText();
        }
        return string;
    }

    protected Font calculateFont(Object object) {
        Font font = this.getFont();
        if (font == null && object instanceof JComponent) {
            font = ((JComponent)object).getFont();
        }
        if (font == null) {
            font = new Font("Dialog", 0, 18);
        }
        return font;
    }

    @Override
    protected Shape provideShape(Graphics2D graphics2D, Object object, int n, int n2) {
        Font font = this.calculateFont(object);
        String string = this.calculateText(object);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        GlyphVector glyphVector = font.createGlyphVector(graphics2D.getFontRenderContext(), string);
        return glyphVector.getOutline(0.0f, 0.0f + (float)fontMetrics.getAscent());
    }
}

