/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter.effects;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class AbstractAreaEffect
implements AreaEffect {
    private static final boolean debug = false;
    BufferedImage _clipImage = null;
    private Color brushColor;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int brushSteps;
    private int effectWidth;
    private boolean renderInsideShape;
    private Point2D offset;
    private boolean shouldFillShape;
    private boolean shapeMasked;

    public AbstractAreaEffect() {
        this.setBrushColor(Color.BLACK);
        this.setBrushSteps(10);
        this.setEffectWidth(8);
        this.setRenderInsideShape(false);
        this.setOffset(new Point(4, 4));
        this.setShouldFillShape(true);
        this.setShapeMasked(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(Graphics2D graphics2D, Shape shape, int n, int n2) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.isEmpty()) {
            return;
        }
        n = (int)(rectangle2D.getWidth() + rectangle2D.getX());
        n2 = (int)(rectangle2D.getHeight() + rectangle2D.getY());
        Rectangle rectangle = new Rectangle(0, 0, n + this.getEffectWidth() * 2 + 1, n2 + this.getEffectWidth() * 2 + 1);
        assert (!rectangle.isEmpty());
        if (this.isShapeMasked()) {
            BufferedImage bufferedImage = this.getClipImage(rectangle);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            try {
                graphics2D2.setPaint(Color.BLACK);
                graphics2D2.setComposite(AlphaComposite.Clear);
                graphics2D2.fillRect(0, 0, rectangle.width, rectangle.height);
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D2.translate((double)this.getEffectWidth() - this.getOffset().getX(), (double)this.getEffectWidth() - this.getOffset().getY());
                this.paintBorderGlow(graphics2D2, shape, n, n2);
                graphics2D2.setComposite(AlphaComposite.Clear);
                graphics2D2.setColor(Color.WHITE);
                if (this.isRenderInsideShape()) {
                    Area area = new Area(rectangle);
                    area.subtract(new Area(shape));
                    graphics2D2.fill(area);
                } else {
                    graphics2D2.fill(shape);
                }
            }
            finally {
                graphics2D2.dispose();
            }
            graphics2D.drawImage((Image)bufferedImage, -this.getEffectWidth() + (int)this.getOffset().getX(), -this.getEffectWidth() + (int)this.getOffset().getY(), null);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintBorderGlow(graphics2D, shape, n, n2);
        }
    }

    private BufferedImage getClipImage(Rectangle rectangle) {
        if (this._clipImage == null || this._clipImage.getWidth() != rectangle.width || this._clipImage.getHeight() != rectangle.height) {
            this._clipImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        }
        this._clipImage.getGraphics().clearRect(0, 0, this._clipImage.getWidth(), this._clipImage.getHeight());
        return this._clipImage;
    }

    protected void paintBorderGlow(Graphics2D graphics2D, Shape shape, int n, int n2) {
        int n3 = this.getBrushSteps();
        float f = 1.0f / (float)n3;
        boolean bl = this.isRenderInsideShape();
        graphics2D.setPaint(this.getBrushColor());
        graphics2D.translate(this.offset.getX(), this.offset.getY());
        if (this.isShouldFillShape()) {
            if (bl) {
                graphics2D.setComposite(AlphaComposite.getInstance(10, 1.0f));
                Area area = new Area(new Rectangle((int)(-this.offset.getX()) - 20, (int)(-this.offset.getY()) - 20, n + 40, n2 + 40));
                Area area2 = new Area(shape);
                area.subtract(area2);
                graphics2D.fill(area);
            } else {
                graphics2D.setComposite(AlphaComposite.getInstance(4, 1.0f));
                graphics2D.fill(shape);
            }
        }
        graphics2D.setComposite(AlphaComposite.getInstance(4, f));
        for (float f2 = 0.0f; f2 < (float)n3; f2 += 1.0f) {
            float f3 = f2 * (float)this.effectWidth / (float)n3;
            graphics2D.setStroke(new BasicStroke(f3, 1, 1));
            graphics2D.draw(shape);
        }
        graphics2D.translate(-this.offset.getX(), -this.offset.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Color getBrushColor() {
        return this.brushColor;
    }

    public void setBrushColor(Color color) {
        Color color2 = this.brushColor;
        this.brushColor = color;
        this.propertyChangeSupport.firePropertyChange("brushColor", color2, color);
    }

    public int getBrushSteps() {
        return this.brushSteps;
    }

    public void setBrushSteps(int n) {
        int n2 = this.brushSteps;
        this.brushSteps = n;
        this.propertyChangeSupport.firePropertyChange("brushSteps", new Integer(n2), new Integer(n));
    }

    public int getEffectWidth() {
        return this.effectWidth;
    }

    public void setEffectWidth(int n) {
        int n2 = this.effectWidth;
        this.effectWidth = n;
        this.propertyChangeSupport.firePropertyChange("effectWidth", new Integer(n2), new Integer(n));
    }

    public boolean isRenderInsideShape() {
        return this.renderInsideShape;
    }

    public void setRenderInsideShape(boolean bl) {
        boolean bl2 = this.renderInsideShape;
        this.renderInsideShape = bl;
        this.propertyChangeSupport.firePropertyChange("renderInsideShape", new Boolean(bl2), new Boolean(bl));
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D point2D) {
        Point2D point2D2 = this.offset;
        this.offset = point2D;
        this.propertyChangeSupport.firePropertyChange("offset", point2D2, point2D);
    }

    public boolean isShouldFillShape() {
        return this.shouldFillShape;
    }

    public void setShouldFillShape(boolean bl) {
        boolean bl2 = this.shouldFillShape;
        this.shouldFillShape = bl;
        this.propertyChangeSupport.firePropertyChange("shouldFillShape", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isShapeMasked() {
        return this.shapeMasked;
    }

    public void setShapeMasked(boolean bl) {
        boolean bl2 = this.shapeMasked;
        this.shapeMasked = bl;
        this.propertyChangeSupport.firePropertyChange("shapeMasked", new Boolean(bl2), new Boolean(bl));
    }
}

