/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

public enum ChangeReason {
    OP_WITHOUT_DIALOG(VisualChange.YES, MakeUndoBackup.YES){}
    ,
    OP_PREVIEW(VisualChange.YES, MakeUndoBackup.NO){}
    ,
    UNDO_REDO(VisualChange.YES, MakeUndoBackup.NO){}
    ,
    PERFORMANCE_TEST(VisualChange.YES, MakeUndoBackup.NO){};

    private VisualChange visualChangeStr;
    private MakeUndoBackup makeUndoBackupStr;

    public boolean makeUndoBackup() {
        return this.makeUndoBackupStr.makeUndoBackup();
    }

    public boolean repaintAndUpdateHistogram() {
        return this.visualChangeStr.updateHistogram();
    }

    private ChangeReason(VisualChange visualChange, MakeUndoBackup makeUndoBackup) {
        this.visualChangeStr = visualChange;
        this.makeUndoBackupStr = makeUndoBackup;
    }

    private static enum MakeUndoBackup {
        YES{

            @Override
            public boolean makeUndoBackup() {
                return true;
            }
        }
        ,
        NO{

            @Override
            public boolean makeUndoBackup() {
                return false;
            }
        };


        public abstract boolean makeUndoBackup();
    }

    private static enum VisualChange {
        YES{

            @Override
            public boolean updateHistogram() {
                return true;
            }
        }
        ,
        NO{

            @Override
            public boolean updateHistogram() {
                return false;
            }
        };


        public abstract boolean updateHistogram();
    }
}

