/*
 * Decompiled with CFR 0.152.
 */
package pixelitor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.CheckerboardPainter;
import pixelitor.Composition;
import pixelitor.ConsistencyChecks;
import pixelitor.ExceptionHandler;
import pixelitor.InternalImageFrame;
import pixelitor.history.History;
import pixelitor.history.ZoomChangeEdit;
import pixelitor.layers.ImageLayer;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerButton;
import pixelitor.layers.LayersContainer;
import pixelitor.layers.LayersPanel;
import pixelitor.menus.ZoomLevel;
import pixelitor.tools.Tools;
import pixelitor.utils.ImageUtils;
import pixelitor.utils.debug.ImageComponentNode;

public class ImageComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private double viewScale = 1.0;
    private InternalImageFrame internalFrame = null;
    private static final Color BG_GRAY = new Color(200, 200, 200);
    private static CheckerboardPainter checkerBoardPainter = new CheckerboardPainter(BG_GRAY, Color.WHITE);
    private LayersPanel layersPanel;
    private int zoomedCanvasWidth;
    private int zoomedCanvasHeight;
    private ZoomLevel zoomLevel = ZoomLevel.Z100;
    private Composition comp;
    private boolean layerMaskEditing = false;

    public ImageComponent(File file, String string, BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("baseLayerImage is null");
        }
        this.comp = new Composition(this, file, string);
        this.init(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public ImageComponent(File file, Composition composition) {
        this.comp = composition;
        composition.setImageComponent(this);
        composition.setFile(file);
        this.init(composition.getCanvasWidth(), composition.getCanvasHeight());
    }

    public void addBaseLayer(BufferedImage bufferedImage) {
        this.comp.updateCanvasSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        ImageLayer imageLayer = new ImageLayer(this.comp, bufferedImage, null);
        this.comp.addLayer((Layer)imageLayer, false, true, false);
    }

    private void init(int n, int n2) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.layersPanel = new LayersPanel();
        this.setCanvasSize(n, n2);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.comp.isEmpty()) {
            return super.getPreferredSize();
        }
        return new Dimension(this.zoomedCanvasWidth, this.zoomedCanvasHeight);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Tools.getCurrentTool().mouseClicked(mouseEvent, this);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Tools.getCurrentTool().mousePressed(mouseEvent, this);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Tools.getCurrentTool().mouseReleased(mouseEvent, this);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Tools.getCurrentTool().mouseDragged(mouseEvent, this);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Tools.getCurrentTool().mouseMoved(mouseEvent, this);
    }

    @Override
    public String toString() {
        ImageComponentNode imageComponentNode = new ImageComponentNode("ImageComponent", this);
        return imageComponentNode.toDetailedString();
    }

    public void setInternalFrame(InternalImageFrame internalImageFrame) {
        this.internalFrame = internalImageFrame;
    }

    public InternalImageFrame getInternalFrame() {
        return this.internalFrame;
    }

    public void close() {
        if (this.internalFrame != null) {
            this.internalFrame.dispose();
        }
        this.comp.dispose();
    }

    public void onActivation() {
        try {
            this.getInternalFrame().setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            ExceptionHandler.showExceptionDialog(propertyVetoException);
        }
        LayersContainer.showLayersPanel(this.layersPanel);
    }

    private void setCanvasSize(int n, int n2) {
        this.comp.setCanvasWidth(n);
        this.comp.setCanvasHeight(n2);
        this.zoomedCanvasWidth = (int)(this.viewScale * (double)n);
        this.zoomedCanvasHeight = (int)(this.viewScale * (double)n2);
        assert (ConsistencyChecks.translationCheck(this.comp));
    }

    public double getViewScale() {
        return this.viewScale;
    }

    public void setZoom(ZoomLevel zoomLevel, boolean bl) {
        ZoomLevel zoomLevel2 = this.zoomLevel;
        this.zoomLevel = zoomLevel;
        if (zoomLevel2 == zoomLevel) {
            return;
        }
        if (bl) {
            ZoomChangeEdit zoomChangeEdit = new ZoomChangeEdit(this.comp, zoomLevel2, this.zoomLevel);
            History.addEdit(zoomChangeEdit);
        }
        int n = zoomLevel.getValue();
        this.viewScale = (double)n / 100.0;
        this.zoomedCanvasWidth = (int)(this.viewScale * (double)this.comp.getCanvasWidth());
        this.zoomedCanvasHeight = (int)(this.viewScale * (double)this.comp.getCanvasHeight());
        if (this.internalFrame != null) {
            this.setInternalFrameTitle();
            this.internalFrame.setNewSize(this.zoomedCanvasWidth, this.zoomedCanvasHeight, -1, -1);
        }
        this.revalidate();
        super.repaint();
    }

    public void setInternalFrameTitle() {
        if (this.internalFrame != null) {
            String string = this.createFrameTitle();
            this.internalFrame.setTitle(string);
        }
    }

    public String createFrameTitle() {
        return this.comp.getName() + " - " + this.zoomLevel.getValue() + " %";
    }

    public ZoomLevel getZoomLevel() {
        return this.zoomLevel;
    }

    public void updateCanvasSize(int n, int n2) {
        this.setCanvasSize(n, n2);
        if (this.internalFrame != null) {
            this.internalFrame.setNewSize(this.zoomedCanvasWidth, this.zoomedCanvasHeight, -1, -1);
        }
        this.revalidate();
    }

    public void addLayerButton(LayerButton layerButton, int n) {
        this.layersPanel.addLayerButton(layerButton, n);
    }

    public void deleteLayerButton(LayerButton layerButton) {
        this.layersPanel.deleteLayerButton(layerButton);
    }

    public Composition getComp() {
        return this.comp;
    }

    public void changeLayerOrderInTheGUI(int n, int n2) {
        this.layersPanel.changeLayerOrder(n, n2);
    }

    public int getZoomedCanvasWidth() {
        return this.zoomedCanvasWidth;
    }

    public int getZoomedCanvasHeight() {
        return this.zoomedCanvasHeight;
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            this.paintComponent(graphics);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ExceptionHandler.showOutOfMemoryDialog();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = ImageComponent.adjustClipBounds(graphics, this.zoomedCanvasWidth, this.zoomedCanvasHeight);
        if (!this.layerMaskEditing) {
            checkerBoardPainter.paint(graphics2D, this, this.zoomedCanvasWidth, this.zoomedCanvasHeight);
        }
        graphics2D.scale(this.viewScale, this.viewScale);
        BufferedImage bufferedImage = this.layerMaskEditing ? this.comp.getActiveLayer().getLayerMask().getBwImage() : this.comp.getCompositeImage();
        ImageUtils.drawImageWithClipping(graphics2D, bufferedImage);
        if (bl) {
            graphics.setClip(0, 0, this.comp.getCanvasWidth() + 1, this.comp.getCanvasHeight() + 1);
        }
        this.comp.paintSelection(graphics2D);
        Tools.getCurrentTool().paintOverImage(graphics2D);
    }

    private static boolean adjustClipBounds(Graphics graphics, int n, int n2) {
        int n3;
        boolean bl = false;
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = rectangle.x + rectangle.width - n;
        if (n4 > 0) {
            rectangle.width -= n4;
            bl = true;
        }
        if ((n3 = rectangle.y + rectangle.height - n2) > 0) {
            rectangle.height -= n3;
            bl = true;
        }
        if (bl) {
            graphics.setClip(rectangle);
        }
        return bl;
    }

    public void updateRegion(int n, int n2, int n3, int n4, int n5) {
        int n6;
        double d = this.viewScale - 1.0;
        if (d > (double)1.0E-4f || d < (double)-1.0E-4f) {
            n = (int)(this.viewScale * (double)n);
            n2 = (int)(this.viewScale * (double)n2);
            n3 = (int)(this.viewScale * (double)n3);
            n4 = (int)(this.viewScale * (double)n4);
            n5 = (int)(this.viewScale * (double)n5);
        }
        if (n3 < n) {
            n6 = n;
            n = n3;
            n3 = n6;
        }
        if (n4 < n2) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
        }
        n6 = (n3 += n5) - (n -= n5);
        int n7 = (n4 += n5) - (n2 -= n5);
        this.repaint(n, n2, n6, n7);
    }

    public void makeSureItIsVisible() {
        if (this.internalFrame != null) {
            this.internalFrame.makeSureItIsVisible();
        }
    }

    public void setLayerMaskEditing(boolean bl) {
        this.layerMaskEditing = bl;
        this.repaint();
    }
}

