/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.automate;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.PixelitorWindow;
import pixelitor.automate.OpenSaveDirsPanel;
import pixelitor.io.FileExtensionUtils;
import pixelitor.io.OpenSaveManager;
import pixelitor.io.OutputFormat;
import pixelitor.utils.CompositionAction;
import pixelitor.utils.Utils;
import pixelitor.utils.ValidatedDialog;

public class Automate {
    private static final String OVERWRITE_YES = "Yes";
    private static final String OVERWRITE_YES_ALL = "Yes, All";
    private static final String OVERWRITE_NO = "No (Skip)";
    private static final String OVERWRITE_CANCEL = "Cancel Processing";

    private Automate() {
    }

    public static void processEachFile(final CompositionAction compositionAction, final boolean bl, String string) {
        File file = OpenSaveManager.getLastOpenDir();
        if (file == null) {
            throw new IllegalStateException("lastOpenDir is null");
        }
        if (!file.exists()) {
            throw new IllegalStateException("Last open dir " + file.getAbsolutePath() + " does not exist");
        }
        final File file2 = OpenSaveManager.getLastSaveDir();
        if (file2 == null) {
            throw new IllegalStateException("lastSaveDir is null");
        }
        if (!file2.exists()) {
            throw new IllegalStateException("Last save dir " + file2.getAbsolutePath() + " does not exist");
        }
        final File[] fileArray = FileExtensionUtils.getAllSupportedFilesInDir(file);
        if (fileArray.length == 0) {
            ExceptionHandler.showInfoDialog("No files", "There are no supported files in " + file.getAbsolutePath());
            return;
        }
        final ProgressMonitor progressMonitor = Utils.createProgressMonitor(string);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                boolean bl2 = false;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file = fileArray[i];
                    progressMonitor.setProgress((int)((float)i * 100.0f / (float)n));
                    progressMonitor.setNote("Processing " + file.getName());
                    System.out.println("Processing " + file.getName());
                    if (progressMonitor.isCanceled()) break;
                    OpenSaveManager.openFile(file);
                    final Composition composition = AppLogic.getActiveComp();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            compositionAction.process(composition);
                        }
                    };
                    try {
                        EventQueue.invokeAndWait(runnable);
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionHandler.showExceptionDialog(interruptedException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ExceptionHandler.showExceptionDialog(invocationTargetException);
                    }
                    OutputFormat outputFormat = OutputFormat.getLastOutputFormat();
                    String string = file.getName();
                    String string2 = FileExtensionUtils.replaceExtension(string, outputFormat.toString());
                    File file22 = new File(file2, string2);
                    if (file22.exists() && !bl2) {
                        JOptionPane jOptionPane = new JOptionPane("File " + file22 + " already exists. Overwrite?", 2);
                        jOptionPane.setOptions(new String[]{Automate.OVERWRITE_YES, Automate.OVERWRITE_YES_ALL, Automate.OVERWRITE_NO, Automate.OVERWRITE_CANCEL});
                        jOptionPane.setInitialValue(Automate.OVERWRITE_NO);
                        JDialog jDialog = jOptionPane.createDialog(PixelitorWindow.getInstance(), "Warning");
                        jDialog.setVisible(true);
                        String string3 = (String)jOptionPane.getValue();
                        String string4 = string3 == null ? Automate.OVERWRITE_CANCEL : string3;
                        if (string4.equals(Automate.OVERWRITE_YES)) {
                            outputFormat.saveComposition(composition, file22);
                        } else if (string4.equals(Automate.OVERWRITE_YES_ALL)) {
                            outputFormat.saveComposition(composition, file22);
                            bl2 = true;
                        } else if (!string4.equals(Automate.OVERWRITE_NO) && string4.equals(Automate.OVERWRITE_CANCEL)) {
                            if (!bl) break;
                            OpenSaveManager.warnAndCloseImage(composition.getIC());
                            break;
                        }
                    } else {
                        outputFormat.saveComposition(composition, file22);
                    }
                    if (!bl) continue;
                    OpenSaveManager.warnAndCloseImage(composition.getIC());
                }
                progressMonitor.close();
                return null;
            }
        };
        swingWorker.execute();
    }

    public static boolean selectInputAndOutputDir(boolean bl, String string) {
        OpenSaveDirsPanel openSaveDirsPanel = new OpenSaveDirsPanel(bl);
        ValidatedDialog validatedDialog = new ValidatedDialog(openSaveDirsPanel, (Frame)PixelitorWindow.getInstance(), string);
        validatedDialog.setVisible(true);
        if (!validatedDialog.isOkPressed()) {
            return false;
        }
        openSaveDirsPanel.saveValues();
        return true;
    }
}

