/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.impl.CircleToSquareFilter;

public class CircleToSquare
extends FilterWithSOParametrizedGUI {
    private RangeParam radius = new RangeParam("Radius", 10, 999, 100);
    private RangeParam amount = new RangeParam("Amount (%)", -200, 200, 100);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private CircleToSquareFilter filter;

    public CircleToSquare() {
        super("Circle to Square");
        this.paramSet = new ParamSet(this.center, this.radius, this.amount, this.edgeAction, this.interpolation, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new CircleToSquareFilter();
        }
        this.filter.setCenterX(this.center.getRelativeX());
        this.filter.setCenterY(this.center.getRelativeY());
        this.filter.setRadius(this.radius.getValue());
        this.filter.setAmount(this.amount.getValueAsPercentage());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

