/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.jdesktop.swingx.image.StackBlurFilter;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.CoupledRangeParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.Utils;

public class Collage
extends FilterWithParametrizedGUI {
    private CoupledRangeParam sizeParam = new CoupledRangeParam("Photo Size", 40, 999, 200);
    private RangeParam marginSizeParam = new RangeParam("Margin", 0, 20, 5);
    private RangeParam imageNumberParam = new RangeParam("Number of Images", 1, 100, 10);
    private RangeParam randomRotationParam = new RangeParam("Random Rotation Amount (%)", 0, 100, 100);
    private BooleanParam allowOutsideParam = new BooleanParam("Allow Outside", true);
    private ColorParam bgColorParam = new ColorParam("Background Color:", Color.BLACK, true, false);
    private RangeParam shadowOpacityParam = new RangeParam("Shadow Opacity (%)", 0, 100, 80);
    private AngleParam shadowAngleParam = new AngleParam("Shadow Angle", 0.7);
    private RangeParam shadowDistanceParam = new RangeParam("Shadow Distance", 0, 20, 5);
    private RangeParam shadowSoftnessParam = new RangeParam("Shadow Softness", 0, 10, 3);
    private Random rand;
    private long seed;
    private ActionParam reseedAction = new ActionParam("Reseed", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collage.this.reseed();
        }
    });

    public Collage() {
        super("Photo Collage");
        this.paramSet = new ParamSet(this.imageNumberParam, this.sizeParam, this.randomRotationParam, this.allowOutsideParam, this.marginSizeParam, this.bgColorParam, this.shadowOpacityParam, this.shadowAngleParam, this.shadowDistanceParam, this.shadowSoftnessParam, this.reseedAction);
        this.seed = System.nanoTime();
        this.rand = new Random(this.seed);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.rand.setSeed(this.seed);
        int n = this.sizeParam.getFirstValue();
        int n2 = this.sizeParam.getSecondValue();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setColor(this.bgColorParam.getColor());
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        int n3 = this.marginSizeParam.getValue();
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(-n3, -n3);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
        int n4 = this.shadowSoftnessParam.getValue();
        int n5 = 1 + (int)(2.3 * (double)n4);
        BufferedImage bufferedImage3 = new BufferedImage(n + 2 * n5, n2 + 2 * n5, 2);
        Graphics2D graphics2D2 = bufferedImage3.createGraphics();
        graphics2D2.setColor(Color.BLACK);
        graphics2D2.fillRect(n5, n5, n, n2);
        graphics2D2.dispose();
        if (n4 > 0) {
            bufferedImage3 = new StackBlurFilter(n4).filter(bufferedImage3, bufferedImage3);
        }
        Point2D point2D = Utils.calculateOffset(this.shadowDistanceParam.getValue(), this.shadowAngleParam.getValueInRadians());
        int n6 = (int)point2D.getX();
        int n7 = (int)point2D.getY();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.shadowOpacityParam.getValueAsPercentage());
        for (int i = 0; i < this.imageNumberParam.getValue(); ++i) {
            Shape shape;
            double d;
            int n8;
            int n9;
            if (this.allowOutsideParam.getValue()) {
                n9 = this.rand.nextInt(bufferedImage2.getWidth() + n) - n;
                n8 = this.rand.nextInt(bufferedImage2.getHeight() + n2) - n2;
            } else {
                int n10 = bufferedImage2.getWidth() - n;
                int n11 = bufferedImage2.getHeight() - n2;
                if (n10 <= 0) {
                    n10 = 1;
                }
                if (n11 <= 0) {
                    n11 = 1;
                }
                n9 = this.rand.nextInt(n10);
                n8 = this.rand.nextInt(n11);
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n9, n8);
            float f = this.randomRotationParam.getValueAsPercentage();
            if (f == 0.0f) {
                d = 0.0;
            } else {
                d = Math.PI * 2 * (double)this.rand.nextFloat() - Math.PI;
                d *= (double)f;
            }
            affineTransform.rotate(d, (double)n / 2.0, (double)n2 / 2.0);
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n6, n7);
            affineTransform2.concatenate(affineTransform);
            affineTransform2.translate(-n5, -n5);
            graphics2D.setComposite(alphaComposite);
            graphics2D.drawImage(bufferedImage3, affineTransform2, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            Shape shape2 = affineTransform.createTransformedShape(rectangle);
            if (n3 > 0) {
                shape = affineTransform.createTransformedShape(rectangle2);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fill(shape2);
            } else {
                shape = shape2;
            }
            graphics2D.setPaint(texturePaint);
            graphics2D.fill(shape);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private void reseed() {
        this.seed = System.nanoTime();
    }
}

