/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class DrawGrid
extends FilterWithParametrizedGUI {
    private RangeParam widthParam = new RangeParam("Width", 1, 100, 2);
    private RangeParam spacingParam = new RangeParam("Spacing", 1, 100, 10);
    private ColorParam colorParam = new ColorParam("Color:", Color.BLACK, true, true);

    public DrawGrid() {
        super("Draw Grid");
        this.paramSet = new ParamSet(this.spacingParam, this.widthParam, this.colorParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        Color color = this.colorParam.getColor();
        int n = this.widthParam.getValue();
        int n2 = this.spacingParam.getValue();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(color);
        ImageUtils.drawGrid(graphics2D, bufferedImage2.getWidth(), bufferedImage2.getHeight(), n, n2, n, n2);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

