/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.history.FadeableEdit;
import pixelitor.history.History;
import pixelitor.utils.ImageUtils;

public class Fade
extends FilterWithParametrizedGUI {
    private static final int FADE_MIN = 0;
    private static final int FADE_MAX = 100;
    private static final int FADE_INIT = 100;
    private RangeParam opacityParam = new RangeParam("Opacity (%)", 0, 100, 100);

    public Fade() {
        super("Fade");
        this.paramSet = new ParamSet((GUIParam)this.opacityParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.opacityParam.getValue() == 100) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        FadeableEdit fadeableEdit = History.getPreviousEditForFade(AppLogic.getActiveComp());
        if (fadeableEdit == null) {
            throw new IllegalStateException();
        }
        BufferedImage bufferedImage3 = fadeableEdit.getBackupImage();
        if (bufferedImage3 == null) {
            throw new IllegalStateException();
        }
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        int n = nArray.length;
        int[] nArray3 = ImageUtils.getPixelsAsArray(bufferedImage3);
        if (n != nArray3.length) {
            Composition composition;
            Composition composition2 = AppLogic.getActiveComp();
            if (composition2 != (composition = fadeableEdit.getComp())) {
                throw new IllegalArgumentException("activeComp != previousComp");
            }
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            int n4 = bufferedImage3.getWidth();
            int n5 = bufferedImage3.getHeight();
            String string = "Fade.transform width = " + n2 + ", height = " + n3 + ", previousWidth = " + n4 + ", previousHeight = " + n5;
            string = string + " comp = " + composition2.getName();
            throw new IllegalArgumentException("the image and the previous are not the same size: " + string);
        }
        float f = this.opacityParam.getValueAsPercentage();
        for (int i = 0; i < n; ++i) {
            int n6 = nArray[i];
            int n7 = n6 >>> 24 & 0xFF;
            int n8 = n6 >>> 16 & 0xFF;
            int n9 = n6 >>> 8 & 0xFF;
            int n10 = n6 & 0xFF;
            int n11 = nArray3[i];
            int n12 = n11 >>> 24 & 0xFF;
            int n13 = n11 >>> 16 & 0xFF;
            int n14 = n11 >>> 8 & 0xFF;
            int n15 = n11 & 0xFF;
            n7 = (int)((float)n12 + f * (float)(n7 - n12));
            n8 = (int)((float)n13 + f * (float)(n8 - n13));
            n9 = (int)((float)n14 + f * (float)(n9 - n14));
            n10 = (int)((float)n15 + f * (float)(n10 - n15));
            nArray2[i] = n7 << 24 | n8 << 16 | n9 << 8 | n10;
        }
        return bufferedImage2;
    }

    public void setOpacity(int n) {
        this.opacityParam.setValue(n);
    }
}

