/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.image.AbstractFilter;
import org.jdesktop.swingx.image.FastBlurFilter;
import org.jdesktop.swingx.image.StackBlurFilter;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class FastBlur
extends FilterWithSOParametrizedGUI {
    private RangeParam radiusParam = new RangeParam("Radius", 0, 100, 0);
    private BooleanParam hpSharpening = BooleanParam.createParamForHPSharpening();
    private static final int METHOD_BETTER = 1;
    private static final int METHOD_FASTER = 2;
    private IntChoiceParam qualityParam = new IntChoiceParam("Quality", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Better", 1), new IntChoiceParam.Value("Faster", 2)});

    public FastBlur() {
        super("Fast Blur");
        this.paramSet = new ParamSet(this.radiusParam, this.qualityParam, this.hpSharpening, this.showOriginalParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = this.radiusParam.getValue();
        if (n == 0) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        AbstractFilter abstractFilter = null;
        int n2 = this.qualityParam.getValue();
        if (n2 == 1) {
            abstractFilter = new StackBlurFilter(this.radiusParam.getValue());
        } else if (n2 == 2) {
            abstractFilter = new FastBlurFilter(n);
        } else {
            throw new IllegalStateException("method = " + n2);
        }
        bufferedImage2 = abstractFilter.filter(bufferedImage, bufferedImage2);
        if (this.hpSharpening.getValue()) {
            bufferedImage2 = ImageUtils.getHighPassSharpenedImage(bufferedImage, bufferedImage2);
        }
        return bufferedImage2;
    }
}

