/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import com.jhlabs.image.Colormap;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.GradientParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.utils.ImageUtils;

public class GradientMap
extends FilterWithParametrizedGUI {
    private GradientParam gradientParam = new GradientParam("Colors", Color.BLACK, Color.WHITE);

    public GradientMap() {
        super("Gradient Map");
        this.paramSet = new ParamSet((GUIParam)this.gradientParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Colormap colormap = this.gradientParam.getValue();
        int[] nArray = new int[256];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = colormap.getColor((float)i / 255.0f);
        }
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray3 = ImageUtils.getPixelsAsArray(bufferedImage2);
        for (int i = 0; i < nArray3.length; ++i) {
            int n = nArray2[i];
            int n2 = n >>> 24 & 0xFF;
            int n3 = n >>> 16 & 0xFF;
            int n4 = n >>> 8 & 0xFF;
            int n5 = n & 0xFF;
            int n6 = (n3 + n4 + n5) / 3;
            nArray3[i] = nArray[n6];
        }
        return bufferedImage2;
    }
}

