/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import com.jhlabs.composite.DifferenceComposite;
import com.jhlabs.composite.ScreenComposite;
import com.jhlabs.image.PolarFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ShortLookupTable;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.filters.Clouds;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.ActionParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.lookup.FastLookupOp;
import pixelitor.utils.ImageUtils;

public class Lightning
extends FilterWithParametrizedGUI {
    private RangeParam numberOfBoltsParam = new RangeParam("Number of Bolts", 1, 20, 8);
    private ImagePositionParam centerParam = new ImagePositionParam("Center");
    private ColorParam colorParam = new ColorParam("Color:", Color.WHITE, false, false);
    private RangeParam boltExpansionParam = new RangeParam("Bolt Expansion", 1, 255, 70);
    public static final int MATH_ATAN = 0;
    public static final int FAST_ATAN = 1;
    private ActionParam reseedAction = new ActionParam("Reseed", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Clouds.reseed();
        }
    });

    public Lightning() {
        super("Lightning");
        this.paramSet = new ParamSet(this.centerParam, this.numberOfBoltsParam, this.boltExpansionParam, this.colorParam, this.reseedAction);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        boolean bl = false;
        int n = this.numberOfBoltsParam.getValue();
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 2 * Math.max(n2, n3);
        int n5 = n4 / (n * 2);
        BufferedImage bufferedImage3 = new BufferedImage(n4, n4, 2);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, n5, 0.0f, ImageUtils.FRACTIONS_2_COLOR_UNIFORM, new Color[]{Color.BLACK, Color.WHITE}, MultipleGradientPaint.CycleMethod.REFLECT);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight());
        graphics2D.dispose();
        Composition composition = null;
        if (bl) {
            composition = AppLogic.getActiveComp();
            AppLogic.debugImage(bufferedImage3, "lightningImage before polar");
        }
        PolarFilter polarFilter = new PolarFilter(0);
        polarFilter.setEdgeAction(0);
        polarFilter.setInterpolation(0);
        bufferedImage3 = polarFilter.filter(bufferedImage3, bufferedImage3);
        if (bl) {
            AppLogic.debugImage(bufferedImage3, "lightningImage after polar");
        }
        int n6 = bufferedImage3.getWidth() - n2;
        int n7 = bufferedImage3.getHeight() - n3;
        int n8 = -n6 / 2 + (int)((double)n2 * ((double)this.centerParam.getRelativeX() - 0.5));
        int n9 = -n7 / 2 + (int)((double)n3 * ((double)this.centerParam.getRelativeY() - 0.5));
        BufferedImage bufferedImage4 = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D2 = bufferedImage4.createGraphics();
        graphics2D2.drawImage((Image)bufferedImage3, n8, n9, null);
        BufferedImage bufferedImage5 = new BufferedImage(n2, n3, 2);
        Clouds.renderClouds(bufferedImage5, 100, 0.5f, Color.BLACK, Color.WHITE);
        graphics2D2.setComposite(new DifferenceComposite(1.0f));
        graphics2D2.drawImage((Image)bufferedImage5, 0, 0, null);
        graphics2D2.dispose();
        if (bl) {
            // empty if block
        }
        int n10 = this.boltExpansionParam.getValue();
        short[] sArray = new short[256];
        for (int n11 = 0; n11 < sArray.length; n11 = (int)((short)(n11 + 1))) {
            sArray[n11] = n11 >= n10 ? (short)0 : (short)(255 * (n10 - n11) / n10);
        }
        short[][] sArray2 = new short[3][256];
        sArray2[0] = sArray;
        sArray2[1] = sArray;
        sArray2[2] = sArray;
        Color color = this.colorParam.getColor();
        if (!color.equals(Color.WHITE)) {
            int n12 = color.getRed();
            int n13 = color.getBlue();
            int n14 = color.getGreen();
            for (int i = 0; i < 256; ++i) {
                short s = sArray2[0][i];
                float f = (float)(s - 255) / 128.0f;
                if (f < 0.0f) {
                    f = -f;
                }
                sArray2[0][i] = (short)((short)((float)n12 * f) + sArray2[0][i]);
                sArray2[1][i] = (short)((short)((float)n14 * f) + sArray2[0][i]);
                sArray2[2][i] = (short)((short)((float)n13 * f) + sArray2[0][i]);
            }
        }
        BufferedImage bufferedImage6 = new BufferedImage(n2, n3, 2);
        bufferedImage6 = new FastLookupOp(new ShortLookupTable(0, sArray2)).filter(bufferedImage4, bufferedImage6);
        if (bl) {
            AppLogic.setActiveImageComponent(composition.getIC(), true);
        }
        bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        Graphics2D graphics2D3 = bufferedImage2.createGraphics();
        graphics2D3.setComposite(new ScreenComposite(1.0f));
        graphics2D3.drawImage((Image)bufferedImage6, 0, 0, null);
        graphics2D3.dispose();
        return bufferedImage2;
    }
}

