/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.Color;
import javax.swing.Action;
import pixelitor.filters.PixelFilter;
import pixelitor.filters.RGBPixelOp;

public class NoDialogPixelOpFactory {
    private NoDialogPixelOpFactory() {
    }

    public static Action getRedChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                n3 = n2;
                n4 = n2;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Red (as BW)", rGBPixelOp);
    }

    public static Action getGreenChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                n2 = n3;
                n4 = n3;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Green (as BW)", rGBPixelOp);
    }

    public static Action getBlueChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                n2 = n4;
                n3 = n4;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Blue (as BW)", rGBPixelOp);
    }

    public static Action getValueChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                int n5;
                int n6;
                int n7 = n6 = n2 > n3 ? n2 : n3;
                if (n4 > n6) {
                    n6 = n4;
                }
                n2 = n5 = n6;
                n3 = n5;
                n4 = n5;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Value = max(R,G,B)", rGBPixelOp);
    }

    public static Action getDesaturateChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                int n5;
                int n6;
                int n7;
                int n8 = n7 = n2 > n3 ? n2 : n3;
                if (n4 > n7) {
                    n7 = n4;
                }
                int n9 = n6 = n2 < n3 ? n2 : n3;
                if (n4 < n6) {
                    n6 = n4;
                }
                n2 = n5 = (n7 + n6) / 2;
                n3 = n5;
                n4 = n5;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Desaturate", rGBPixelOp);
    }

    public static Action getSaturationChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                int n5;
                int n6;
                int n7 = n6 = n2 > n3 ? n2 : n3;
                if (n4 > n6) {
                    n6 = n4;
                }
                int n8 = n5 = n2 < n3 ? n2 : n3;
                if (n4 < n5) {
                    n5 = n4;
                }
                int n9 = 0;
                if (n6 != 0) {
                    n9 = (int)((float)(n6 - n5) / (float)n6 * 255.0f);
                }
                n2 = n9;
                n3 = n9;
                n4 = n9;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Saturation", rGBPixelOp);
    }

    public static Action getHueChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){
            private float[] tmpHSBArray = new float[]{0.0f, 0.0f, 0.0f};

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                int n5;
                this.tmpHSBArray = Color.RGBtoHSB(n2, n3, n4, this.tmpHSBArray);
                n2 = n5 = (int)(this.tmpHSBArray[0] * 255.0f);
                n3 = n5;
                n4 = n5;
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return new PixelFilter("Hue", rGBPixelOp);
    }

    public static Action getHueInColorsChannelOp() {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){
            private static final float DEFAULT_SATURATION = 0.9f;
            private static final float DEFAULT_BRIGHTNESS = 0.75f;
            private float[] tmpHSBArray = new float[]{0.0f, 0.0f, 0.0f};

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                if (n == 0) {
                    return 0;
                }
                this.tmpHSBArray = Color.RGBtoHSB(n2, n3, n4, this.tmpHSBArray);
                int n5 = Color.HSBtoRGB(this.tmpHSBArray[0], 0.9f, 0.75f);
                return n << 24 | (n5 &= 0xFFFFFF);
            }
        };
        return new PixelFilter("Hue (with colors)", rGBPixelOp);
    }
}

