/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import com.jhlabs.composite.MultiplyComposite;
import com.jhlabs.image.BoxBlurFilter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithSOParametrizedGUI;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class Orton
extends FilterWithSOParametrizedGUI {
    private RangeParam blurRadiusParam = new RangeParam("Blur Radius", 0, 10, 3);
    private RangeParam amountParam = new RangeParam("Amount (%)", 0, 100, 100);

    public Orton() {
        super("Orton Effect");
        this.paramSet = new ParamSet(this.showOriginalParam, this.blurRadiusParam, this.amountParam);
    }

    @Override
    public BufferedImage realTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        int n = this.blurRadiusParam.getValue();
        float f = this.amountParam.getValueAsPercentage();
        bufferedImage2 = ImageUtils.copyImage(bufferedImage);
        ImageUtils.screenWithItself(bufferedImage2, f);
        BufferedImage bufferedImage3 = ImageUtils.copyImage(bufferedImage2);
        if (n > 0) {
            object = new BoxBlurFilter(n, n, 3);
            bufferedImage3 = ((BoxBlurFilter)object).filter(bufferedImage3, bufferedImage3);
        }
        object = bufferedImage2.createGraphics();
        ((Graphics2D)object).setComposite(new MultiplyComposite(f));
        ((Graphics)object).drawImage(bufferedImage3, 0, 0, null);
        ((Graphics)object).dispose();
        return bufferedImage2;
    }
}

