/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.ImageUtils;

public class Solarize
extends FilterWithParametrizedGUI {
    private static final int TYPE_CLASSIC = 1;
    private static final int TYPE_INVERTED = 2;
    private RangeParam redThresholdParam = new RangeParam("Red Threshold", 0, 255, 128);
    private RangeParam greenThresholdParam = new RangeParam("Green Threshold", 0, 255, 128);
    private RangeParam blueThresholdParam = new RangeParam("Blue Threshold", 0, 255, 128);
    private IntChoiceParam type = new IntChoiceParam("Type", new IntChoiceParam.Value[]{new IntChoiceParam.Value("Classic", 1), new IntChoiceParam.Value("Upside Down Curve", 2)}, true);

    public Solarize() {
        super("Solarize");
        this.paramSet = new ParamSet(this.type, this.redThresholdParam, this.greenThresholdParam, this.blueThresholdParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int[] nArray2 = ImageUtils.getPixelsAsArray(bufferedImage2);
        int n2 = this.redThresholdParam.getValue();
        int n3 = this.greenThresholdParam.getValue();
        int n4 = this.blueThresholdParam.getValue();
        float f = 255.0f / (float)n2;
        float f2 = 255.0f / (255.0f - (float)n2);
        float f3 = 255.0f / (float)n3;
        float f4 = 255.0f / (255.0f - (float)n3);
        float f5 = 255.0f / (float)n4;
        float f6 = 255.0f / (255.0f - (float)n4);
        int[] nArray3 = new int[256];
        int[] nArray4 = new int[256];
        int[] nArray5 = new int[256];
        int n5 = this.type.getValue();
        if (n5 == 1) {
            for (n = 0; n < 256; ++n) {
                nArray3[n] = n > n2 ? 255 - (int)(f2 * (float)(n - n2)) : 255 - (int)(f * (float)(n2 - n));
                nArray4[n] = n > n3 ? 255 - (int)(f4 * (float)(n - n3)) : 255 - (int)(f3 * (float)(n3 - n));
                nArray5[n] = n > n4 ? 255 - (int)(f6 * (float)(n - n4)) : 255 - (int)(f5 * (float)(n4 - n));
            }
        } else if (n5 == 2) {
            for (n = 0; n < 256; ++n) {
                nArray3[n] = n > n2 ? (int)(f2 * (float)(n - n2)) : (int)(f * (float)(n2 - n));
                nArray4[n] = n > n3 ? (int)(f4 * (float)(n - n3)) : (int)(f3 * (float)(n3 - n));
                nArray5[n] = n > n4 ? (int)(f6 * (float)(n - n4)) : (int)(f5 * (float)(n4 - n));
            }
        }
        int n6 = nArray2.length;
        for (n = 0; n < n6; ++n) {
            int n7 = nArray[n];
            int n8 = n7 >>> 24 & 0xFF;
            if (n8 == 0) {
                nArray2[n] = 0;
                continue;
            }
            int n9 = n7 >>> 16 & 0xFF;
            int n10 = n7 >>> 8 & 0xFF;
            int n11 = n7 & 0xFF;
            int n12 = nArray3[n9];
            int n13 = nArray4[n10];
            int n14 = nArray5[n11];
            nArray2[n] = n8 << 24 | n12 << 16 | n13 << 8 | n14;
        }
        return bufferedImage2;
    }
}

