/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters;

import java.awt.image.BufferedImage;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.RGBPixelOp;
import pixelitor.filters.gui.GUIParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.SliderSpinner;

public class Threshold
extends FilterWithParametrizedGUI {
    private RangeParam intParam = new RangeParam("Threshold", 0, 255, 128, false, SliderSpinner.TextPosition.BORDER);

    public Threshold() {
        super("Threshold");
        this.paramSet = new ParamSet((GUIParam)this.intParam);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        RGBPixelOp rGBPixelOp = new RGBPixelOp(){

            @Override
            public int changeRGB(int n, int n2, int n3, int n4) {
                int n5 = (int)(0.299 * (double)n2 + 0.587 * (double)n3 + 0.114 * (double)n4);
                if (n5 > Threshold.this.intParam.getValue()) {
                    n2 = 255;
                    n3 = 255;
                    n4 = 255;
                } else {
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                }
                return n << 24 | n2 << 16 | n3 << 8 | n4;
            }
        };
        return FilterUtils.runRGBPixelOp(rGBPixelOp, bufferedImage, bufferedImage2);
    }
}

