/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.ImagePositionSelector;
import pixelitor.filters.gui.ParamGUI;
import pixelitor.filters.gui.RangeParam;
import pixelitor.utils.SliderSpinner;

public class ImagePositionPanel
extends JPanel
implements ParamGUI {
    private ImagePositionParam model;
    private RangeParam xSliderModel = new RangeParam("Horizontal Position (%)", 0, 100, 50, true, SliderSpinner.TextPosition.NORTH);
    private RangeParam ySliderModel = new RangeParam("Vertical Position (%)", 0, 100, 50, true, SliderSpinner.TextPosition.NORTH);
    private ImagePositionSelector imagePositionSelector;
    private boolean slidersMovedFromTheImage = false;

    public ImagePositionPanel(final ImagePositionParam imagePositionParam) {
        this.model = imagePositionParam;
        this.setBorder(BorderFactory.createTitledBorder(imagePositionParam.getName()));
        this.setLayout(new BorderLayout(10, 0));
        this.imagePositionSelector = new ImagePositionSelector(this, imagePositionParam, 100);
        this.add((Component)this.imagePositionSelector, "West");
        Box box = Box.createVerticalBox();
        JComponent jComponent = this.xSliderModel.createGUI();
        box.add(jComponent);
        JComponent jComponent2 = this.ySliderModel.createGUI();
        box.add(jComponent2);
        this.add((Component)box, "Center");
        this.xSliderModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ImagePositionPanel.this.slidersMovedFromTheImage) {
                    imagePositionParam.setRelativeX((float)ImagePositionPanel.this.xSliderModel.getValue() / 100.0f);
                    ImagePositionPanel.this.imagePositionSelector.repaint();
                    if (!ImagePositionPanel.this.xSliderModel.getValueIsAdjusting()) {
                        imagePositionParam.getAdjustingListener().paramAdjusted();
                    }
                }
            }
        });
        this.ySliderModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ImagePositionPanel.this.slidersMovedFromTheImage) {
                    imagePositionParam.setRelativeY((float)ImagePositionPanel.this.ySliderModel.getValue() / 100.0f);
                    ImagePositionPanel.this.imagePositionSelector.repaint();
                    if (!ImagePositionPanel.this.ySliderModel.getValueIsAdjusting()) {
                        imagePositionParam.getAdjustingListener().paramAdjusted();
                    }
                }
            }
        });
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = jComponent.getPreferredSize();
        this.setPreferredSize(new Dimension(dimension2.width, dimension.height));
    }

    public void updateSlidersFromModel() {
        this.slidersMovedFromTheImage = true;
        int n = this.xSliderModel.getValue();
        int n2 = (int)(this.model.getRelativeX() * 100.0f);
        if (n2 != n) {
            this.xSliderModel.setValue(n2);
        }
        int n3 = this.ySliderModel.getValue();
        int n4 = (int)(this.model.getRelativeY() * 100.0f);
        if (n4 != n3) {
            this.ySliderModel.setValue(n4);
        }
        this.slidersMovedFromTheImage = false;
    }

    @Override
    public void updateGUI() {
        this.updateSlidersFromModel();
        this.imagePositionSelector.repaint();
    }
}

