/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.util.Random;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import pixelitor.filters.gui.AbstractGUIParam;
import pixelitor.utils.SliderSpinner;

public class RangeParam
extends AbstractGUIParam
implements BoundedRangeModel {
    private int minValue;
    private int maxValue;
    private int defaultValue;
    private int value;
    private boolean adjusting;
    private boolean addDefaultButtons;
    private SliderSpinner.TextPosition textPosition;
    private transient ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private boolean enabled = true;
    private SliderSpinner sliderSpinner;

    public RangeParam(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, true, SliderSpinner.TextPosition.BORDER);
    }

    public RangeParam(String string, int n, int n2, int n3, boolean bl, SliderSpinner.TextPosition textPosition) {
        super(string);
        if (n > n2) {
            throw new IllegalArgumentException(string + ": minValue (" + n + ") > maxValue (" + n2 + ')');
        }
        if (n3 < n) {
            throw new IllegalArgumentException(string + ": defaultValue (" + n3 + ") < minValue (" + n + ')');
        }
        if (n3 > n2) {
            throw new IllegalArgumentException(string + ": defaultValue (" + n3 + ") > maxValue (" + n2 + ')');
        }
        this.minValue = n;
        this.maxValue = n2;
        this.defaultValue = n3;
        this.value = n3;
        this.addDefaultButtons = bl;
        this.textPosition = textPosition;
    }

    @Override
    public boolean isSetToDefault() {
        return this.getValue() == this.defaultValue;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void reset(boolean bl) {
        if (!bl) {
            this.dontTrigger = true;
        }
        this.setValue(this.defaultValue);
        this.dontTrigger = false;
    }

    public float getValueAsPercentage() {
        return (float)this.getValue() / 100.0f;
    }

    public float getValueInRadians() {
        return (float)Math.toRadians(this.getValue());
    }

    @Override
    public int getNrOfGridBagCols() {
        if (this.textPosition == SliderSpinner.TextPosition.NONE) {
            return 2;
        }
        return 1;
    }

    @Override
    public void randomize() {
        int n = this.maxValue - this.minValue;
        Random random = new Random();
        int n2 = this.minValue + random.nextInt(n);
        this.dontTrigger = true;
        this.setValue(n2);
        this.dontTrigger = false;
    }

    @Override
    public JComponent createGUI() {
        this.sliderSpinner = new SliderSpinner(this, this.addDefaultButtons, this.textPosition);
        this.sliderSpinner.setEnabled(this.enabled);
        return this.sliderSpinner;
    }

    public void increaseValue() {
        if (this.value < this.maxValue) {
            this.setValue(this.value + 1);
        }
    }

    public void decreaseValue() {
        if (this.value > this.minValue) {
            this.setValue(this.value - 1);
        }
    }

    @Override
    public int getMinimum() {
        return this.minValue;
    }

    @Override
    public void setMinimum(int n) {
        this.minValue = n;
    }

    @Override
    public int getMaximum() {
        return this.maxValue;
    }

    @Override
    public void setMaximum(int n) {
        this.maxValue = n;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int n) {
        if (this.value != n) {
            this.value = n;
            this.fireStateChanged();
            if (!this.adjusting && !this.dontTrigger && this.adjustmentListener != null) {
                this.adjustmentListener.paramAdjusted();
            }
        }
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        if (!bl && this.adjusting && this.adjustmentListener != null) {
            this.adjustmentListener.paramAdjusted();
        }
        if (this.adjusting != bl) {
            this.adjusting = bl;
            this.fireStateChanged();
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.adjusting;
    }

    @Override
    public int getExtent() {
        return 0;
    }

    @Override
    public void setExtent(int n) {
    }

    @Override
    public void setRangeProperties(int n, int n2, int n3, int n4, boolean bl) {
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null);
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.sliderSpinner != null) {
            this.sliderSpinner.setEnabled(bl);
        }
    }
}

