/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.gui;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pixelitor.Composition;
import pixelitor.ExceptionHandler;
import pixelitor.filters.comp.CompositionUtils;
import pixelitor.utils.GridBagHelper;
import pixelitor.utils.OKCancelDialog;

public class ResizePanel
extends JPanel
implements KeyListener,
ItemListener {
    private static NumberFormat doubleFormatter = new DecimalFormat("#0.00");
    private JCheckBox constrainProportionsCheckBox;
    private JComboBox pixelPercentChooser1;
    private JTextField heightTextField;
    private JTextField widthTextField;
    private double originalProportion;
    private int newWidth;
    private int newHeight;
    private double newWidthInPercent;
    private double newHeightInPercent;
    private int oldWidth;
    private int oldHeight;
    private boolean validData = true;
    private String errorMessage;
    private static final int NR_OF_COLUMNS = 5;

    private ResizePanel(Composition composition) {
        this.oldWidth = composition.getCanvasWidth();
        this.oldHeight = composition.getCanvasHeight();
        this.originalProportion = (double)this.oldWidth / (double)this.oldHeight;
        this.newWidth = this.oldWidth;
        this.newHeight = this.oldHeight;
        this.newWidthInPercent = 100.0;
        this.newHeightInPercent = 100.0;
        String[] stringArray = new String[]{"pixels", "percent"};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagHelper.addLabel((Container)jPanel, "Width:", 0, 0);
        this.widthTextField = new JTextField(5);
        this.widthTextField.addKeyListener(this);
        this.widthTextField.setText(String.valueOf(this.oldWidth));
        GridBagHelper.addControl(jPanel, this.widthTextField);
        this.pixelPercentChooser1 = new JComboBox<String>(defaultComboBoxModel);
        GridBagHelper.addNextControl(jPanel, this.pixelPercentChooser1);
        GridBagHelper.addLabel((Container)jPanel, "Height:", 0, 1);
        this.heightTextField = new JTextField(5);
        this.heightTextField.setText(String.valueOf(this.oldHeight));
        GridBagHelper.addControl(jPanel, this.heightTextField);
        this.heightTextField.addKeyListener(this);
        JComboBox<String> jComboBox = new JComboBox<String>(defaultComboBoxModel);
        GridBagHelper.addNextControl(jPanel, jComboBox);
        jPanel.setBorder(BorderFactory.createTitledBorder("Resize from " + this.oldWidth + 'x' + this.oldHeight));
        Box box = Box.createVerticalBox();
        box.add(jPanel);
        JPanel jPanel2 = new JPanel();
        this.constrainProportionsCheckBox = new JCheckBox("Constrain Proportions");
        this.constrainProportionsCheckBox.setSelected(true);
        jPanel2.add(this.constrainProportionsCheckBox);
        jPanel2.setLayout(new FlowLayout(0));
        box.add(jPanel2);
        this.add(box);
        this.pixelPercentChooser1.addItemListener(this);
        jComboBox.addItemListener(this);
        this.constrainProportionsCheckBox.addItemListener(this);
    }

    private boolean pixelsSelected() {
        return this.pixelPercentChooser1.getSelectedIndex() == 0;
    }

    private boolean constrainProportions() {
        return this.constrainProportionsCheckBox.isSelected();
    }

    private static double parseLocalizedDouble(String string) {
        double d = 100.0;
        try {
            Number number = doubleFormatter.parse(string);
            d = number.doubleValue();
        }
        catch (ParseException parseException) {
            ExceptionHandler.showExceptionDialog(parseException);
        }
        return d;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.constrainProportionsCheckBox) {
            if (this.constrainProportions()) {
                this.newHeight = (int)((double)this.newWidth / this.originalProportion);
                this.newHeightInPercent = this.newWidthInPercent;
                if (this.pixelsSelected()) {
                    this.heightTextField.setText(String.valueOf(this.newHeight));
                } else {
                    this.heightTextField.setText(doubleFormatter.format(this.newHeightInPercent));
                }
            }
        } else if (this.pixelsSelected()) {
            this.widthTextField.setText(String.valueOf(this.newWidth));
            this.heightTextField.setText(String.valueOf(this.newHeight));
        } else {
            this.widthTextField.setText(doubleFormatter.format(this.newWidthInPercent));
            this.heightTextField.setText(doubleFormatter.format(this.newHeightInPercent));
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        block17: {
            this.validData = true;
            this.errorMessage = null;
            if (keyEvent.getSource() == this.widthTextField) {
                if (this.pixelsSelected()) {
                    try {
                        this.newWidth = Integer.parseInt(this.widthTextField.getText());
                        if (this.constrainProportions()) {
                            this.newHeight = (int)((double)this.newWidth / this.originalProportion);
                            this.heightTextField.setText(String.valueOf(this.newHeight));
                            this.newHeightInPercent = (double)this.newHeight * 100.0 / (double)this.oldHeight;
                        }
                        this.newWidthInPercent = (double)this.newWidth * 100.0 / (double)this.oldWidth;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.widthTextField.getText().trim().isEmpty()) {
                            this.validData = false;
                            this.errorMessage = "the 'width' field is empty";
                            break block17;
                        }
                        this.widthTextField.setText(String.valueOf(this.newWidth));
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this.newWidthInPercent = ResizePanel.parseLocalizedDouble(this.widthTextField.getText());
                    this.newWidth = (int)((double)this.oldWidth * this.newWidthInPercent / 100.0);
                    if (this.constrainProportions()) {
                        this.newHeight = (int)((double)this.newWidth / this.originalProportion);
                        this.newHeightInPercent = this.newWidthInPercent;
                        this.heightTextField.setText(doubleFormatter.format(this.newHeightInPercent));
                    }
                }
            } else if (keyEvent.getSource() == this.heightTextField) {
                if (this.pixelsSelected()) {
                    try {
                        this.newHeight = Integer.parseInt(this.heightTextField.getText());
                        if (this.constrainProportions()) {
                            this.newWidth = (int)((double)this.newHeight * this.originalProportion);
                            this.widthTextField.setText(String.valueOf(this.newWidth));
                            this.newWidthInPercent = ResizePanel.parseLocalizedDouble(this.widthTextField.getText());
                        }
                        this.newHeightInPercent = (double)this.newHeight * 100.0 / (double)this.oldHeight;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.heightTextField.getText().trim().isEmpty()) {
                            this.validData = false;
                            this.errorMessage = "the 'height' field is empty";
                            break block17;
                        }
                        this.heightTextField.setText(String.valueOf(this.newHeight));
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    this.newHeightInPercent = ResizePanel.parseLocalizedDouble(this.heightTextField.getText());
                    this.newHeight = (int)((double)this.oldHeight * this.newHeightInPercent / 100.0);
                    if (this.constrainProportions()) {
                        this.newWidth = (int)((double)this.newHeight * this.originalProportion);
                        this.newWidthInPercent = this.newHeightInPercent;
                        this.widthTextField.setText(doubleFormatter.format(this.newWidthInPercent));
                    }
                }
            }
        }
    }

    public boolean validData() {
        if (this.getNewWidth() == 0 || this.getNewHeight() == 0) {
            this.validData = false;
            this.errorMessage = "Width and height cannot be 0";
        }
        return this.validData;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public int getNewHeight() {
        return this.newHeight;
    }

    public static void showInDialog(final Composition composition) {
        final ResizePanel resizePanel = new ResizePanel(composition);
        OKCancelDialog oKCancelDialog = new OKCancelDialog(resizePanel, "Resize"){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                if (!resizePanel.validData()) {
                    JOptionPane.showMessageDialog(this, resizePanel.getErrorMessage(), "Error", 0);
                    return;
                }
                CompositionUtils.resize(composition, resizePanel.getNewWidth(), resizePanel.getNewHeight(), false);
                this.dispose();
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                this.dispose();
            }
        };
        oKCancelDialog.setVisible(true);
    }
}

