/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.impl;

import com.jhlabs.image.TransformFilter;
import java.awt.image.BufferedImage;

public class CircleToSquareFilter
extends TransformFilter {
    private float centerX;
    private float centerY;
    private float radius;
    private int cx;
    private int cy;
    private float amount = 1.0f;

    public void setCenterX(float f) {
        this.centerX = f;
    }

    public void setCenterY(float f) {
        this.centerY = f;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setAmount(float f) {
        this.amount = f;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.cx = (int)(this.centerX * (float)bufferedImage.getWidth());
        this.cy = (int)(this.centerY * (float)bufferedImage.getHeight());
        return super.filter(bufferedImage, bufferedImage2);
    }

    @Override
    protected void transformInverse(int n, int n2, float[] fArray) {
        int n3 = n - this.cx;
        int n4 = n2 - this.cy;
        int n5 = Math.abs(n3);
        int n6 = Math.abs(n4);
        if ((float)n5 > this.radius || (float)n6 > this.radius) {
            fArray[0] = n;
            fArray[1] = n2;
            return;
        }
        double d = n5 >= n6 ? Math.atan2(n4, n5) : Math.atan2(n3, n6);
        double d2 = Math.cos(d);
        float f = (float)this.cx + (float)((double)n3 * d2);
        float f2 = (float)this.cy + (float)((double)n4 * d2);
        if (this.amount == 1.0f) {
            fArray[0] = f;
            fArray[1] = f2;
        } else {
            fArray[0] = (float)n + this.amount * (f - (float)n);
            fArray[1] = (float)n2 + this.amount * (f2 - (float)n2);
        }
    }
}

