/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.CrystallizeFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.BooleanParam;
import pixelitor.filters.gui.ColorParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHCrystallize
extends FilterWithParametrizedGUI {
    private RangeParam edgeThickness = new RangeParam("Edge Thickness", 0, 100, 40);
    private RangeParam size = new RangeParam("Size", 1, 200, 20);
    private ColorParam edgeColor = new ColorParam("Edge Color", Color.BLACK, true, true);
    private BooleanParam fadeEdges = new BooleanParam("Fade Edges", false);
    private RangeParam randomness = new RangeParam("Shape Randomness (%)", 1, 100, 1);
    private IntChoiceParam gridType = IntChoiceParam.getGridTypeChoices("Shape", this.randomness);
    private CrystallizeFilter filter;

    public JHCrystallize() {
        super("Crystallize");
        this.paramSet = new ParamSet(this.size, this.edgeThickness, this.gridType, this.randomness, this.edgeColor, this.fadeEdges);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new CrystallizeFilter();
        }
        this.filter.setEdgeThickness(this.edgeThickness.getValueAsPercentage());
        this.filter.setScale(this.size.getValue());
        this.filter.setRandomness(this.randomness.getValueAsPercentage());
        this.filter.setEdgeColor(this.edgeColor.getColor().getRGB());
        this.filter.setGridType(this.gridType.getValue());
        this.filter.setFadeEdges(this.fadeEdges.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

