/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.jhlabsproxies;

import com.jhlabs.image.KaleidoscopeFilter;
import java.awt.image.BufferedImage;
import pixelitor.filters.FilterWithParametrizedGUI;
import pixelitor.filters.gui.AngleParam;
import pixelitor.filters.gui.ImagePositionParam;
import pixelitor.filters.gui.IntChoiceParam;
import pixelitor.filters.gui.ParamSet;
import pixelitor.filters.gui.RangeParam;

public class JHKaleidoscope
extends FilterWithParametrizedGUI {
    private AngleParam angle = new AngleParam("Angle", 0.0);
    private AngleParam rotateResult = new AngleParam("Rotate Result", 0.0);
    private ImagePositionParam center = new ImagePositionParam("Center");
    private RangeParam sides = new RangeParam("Sides", 0, 10, 3);
    private RangeParam radius = new RangeParam("Radius", 0, 999, 0);
    private IntChoiceParam edgeAction = IntChoiceParam.getEdgeActionChoices();
    private IntChoiceParam interpolation = IntChoiceParam.getInterpolationChoices();
    private KaleidoscopeFilter filter;

    public JHKaleidoscope() {
        super("Kaleidoscope");
        this.paramSet = new ParamSet(this.center, this.rotateResult, this.angle, this.sides, this.radius, this.edgeAction, this.interpolation);
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.filter == null) {
            this.filter = new KaleidoscopeFilter();
        }
        this.filter.setAngle((float)this.angle.getValueInRadians());
        this.filter.setAngle2((float)this.rotateResult.getValueInRadians());
        this.filter.setCentreX(this.center.getRelativeX());
        this.filter.setCentreY(this.center.getRelativeY());
        this.filter.setRadius(this.radius.getValue());
        this.filter.setSides(this.sides.getValue());
        this.filter.setEdgeAction(this.edgeAction.getValue());
        this.filter.setInterpolation(this.interpolation.getValue());
        bufferedImage2 = this.filter.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

